/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.random;

import java.util.Random;

public class BinomialGenerator {
    private Random random = new Random();
    private double[] cummulated;
    private double logProbability;
    private double p;
    private int maxValue;
    private int min;
    private int max;

    public BinomialGenerator(double p, int maxValue) {
        this.p = p;
        this.maxValue = maxValue;
        this.cummulated = new double[maxValue + 1];
        this.init();
    }

    public int nextInt() {
        if (this.cummulated.length == 1) {
            return 0;
        }
        double rand = this.random.nextDouble();
        int start = this.min;
        int end = this.max;
        int s = (start + end) / 2;
        do {
            if (this.cummulated[s] > rand && (s == 0 || this.cummulated[s - 1] <= rand) || s == this.cummulated.length - 1) {
                return s;
            }
            if (this.cummulated[s] < rand) {
                start = s + 1;
            } else if (this.cummulated[s] > rand) {
                end = s - 1;
            }
            s = (start + end) / 2;
        } while (start <= end);
        throw new RuntimeException("An error occured in method nextInt()");
    }

    private void init() {
        boolean lastZero = true;
        this.max = this.cummulated.length - 1;
        for (int i = 0; i < this.cummulated.length; ++i) {
            this.computeNextLogProbability(i);
            if (lastZero && Math.exp(this.logProbability) == 0.0) {
                this.min = i;
            }
            if (Math.exp(this.logProbability) > 0.0) {
                lastZero = false;
                this.max = i;
            }
            if (Double.isNaN(this.logProbability)) {
                throw new ArithmeticException("A problem with cummulative distribution occured.");
            }
            this.cummulated[i] = i != 0 ? Math.exp(this.logProbability) + this.cummulated[i - 1] : Math.exp(this.logProbability);
        }
    }

    private void computeNextLogProbability(int k) {
        int length = this.cummulated.length - 1;
        if (k == 0) {
            int i;
            for (i = 0; i < length; ++i) {
                this.logProbability += Math.log(length - i);
            }
            for (i = 1; i <= length; ++i) {
                this.logProbability -= Math.log(i);
            }
            this.logProbability += (double)length * Math.log(1.0 - this.p);
        } else if (this.p != 0.0 && this.p != 1.0) {
            this.logProbability = this.logProbability + Math.log(length - k + 1) + Math.log(this.p) - Math.log(k) - Math.log(1.0 - this.p);
        } else if (this.p == 1.0 && k == length) {
            this.logProbability = Double.NEGATIVE_INFINITY;
        }
    }
}

