/*
 * Decompiled with CFR 0.152.
 */
package data.aggregate;

import data.aggregate.AggregateFunction;
import data.aggregate.sensitivity.NoSensitivity;
import data.kind.Nominal;
import data.kind.Numeric;
import data.value.Value;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import util.Mutable;

public class Count
extends AggregateFunction<Mutable<Long>> {
    public Count() {
        this.sensitivity = new NoSensitivity();
        this.funcTypeIn = new Nominal();
        this.funcTypeOut = new Numeric();
        this.needsFeature = false;
        this.name = "count";
    }

    public Value aggregate(Stream<Value> in) {
        return new Value(new Double(in.count()));
    }

    @Override
    public Value applyFunction(ArrayList<Value> s) {
        return new Value(Double.valueOf(s.size()));
    }

    @Override
    public Supplier<Mutable<Long>> supplier() {
        return () -> new Mutable<Long>(new Long(0L));
    }

    @Override
    public BiConsumer<Mutable<Long>, Value> accumulator() {
        return (accum, val) -> accum.set((Long)accum.get() + 1L);
    }

    @Override
    public BinaryOperator<Mutable<Long>> combiner() {
        return (a, b) -> {
            a.set((Long)a.get() + (Long)b.get());
            return a;
        };
    }

    @Override
    public Function<Mutable<Long>, Value> finisher() {
        return a -> new Value(((Long)a.get()).doubleValue());
    }
}

