/*
 * Decompiled with CFR 0.152.
 */
package data.aggregate;

import data.aggregate.AggregateFunction;
import data.aggregate.sensitivity.EmptySetSensitivity;
import data.kind.Numeric;
import data.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;

public class InterquartileRange
extends AggregateFunction<ArrayList<Value>> {
    TreeSet<Value> values = new TreeSet();

    public InterquartileRange() {
        this.sensitivity = new EmptySetSensitivity();
        this.funcTypeIn = new Numeric();
        this.funcTypeOut = new Numeric();
        this.needsFeature = true;
        this.name = "interquartile";
    }

    @Override
    public Value applyFunction(ArrayList<Value> s) {
        ArrayList<Double> d = new ArrayList<Double>(s.size());
        for (Value valInt : s) {
            d.add(valInt.getNumericValue());
        }
        Collections.sort(d);
        double q1 = d.size() % 4 == 0 ? (Double)d.get(d.size() / 4 - 1) : (Double)d.get(d.size() / 4);
        double q3 = 3 * d.size() % 4 == 0 ? (Double)d.get(3 * d.size() / 4 - 1) : (Double)d.get(3 * d.size() / 4);
        return new Value(q3 - q1);
    }

    @Override
    public Supplier<ArrayList<Value>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<ArrayList<Value>, Value> accumulator() {
        return (accum, val) -> {
            boolean bl = accum.add(val);
        };
    }

    @Override
    public BinaryOperator<ArrayList<Value>> combiner() {
        return (a, b) -> {
            a.addAll(b);
            return a;
        };
    }

    @Override
    public Function<ArrayList<Value>, Value> finisher() {
        return d -> {
            if (d.isEmpty()) {
                return new Value(null);
            }
            Collections.sort(d);
            int i1 = d.size() % 4 == 0 ? d.size() / 4 - 1 : d.size() / 4;
            int i3 = 3 * d.size() % 4 == 0 ? 3 * d.size() / 4 - 1 : 3 * d.size() / 4;
            return new Value(((Value)d.get(i3)).getNumericValue() - ((Value)d.get(i1)).getNumericValue());
        };
    }
}

