/*
 * Decompiled with CFR 0.152.
 */
package data.aggregate;

import data.aggregate.AggregateFunction;
import data.aggregate.sensitivity.EmptySetSensitivity;
import data.feature.SingleValueFeature;
import data.kind.Nominal;
import data.kind.Numeric;
import data.value.Value;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import util.Couple;
import util.Mutable;

public class Ratio
extends AggregateFunction<Couple<Mutable<Long>, Mutable<Long>>> {
    private SingleValueFeature svf;
    private Value match;

    public Ratio(SingleValueFeature sf, Value m) {
        this.svf = sf;
        this.match = m;
        this.sensitivity = new EmptySetSensitivity();
        this.funcTypeIn = new Nominal();
        this.funcTypeOut = new Numeric();
        this.needsFeature = true;
        this.name = "ratio";
        if (m != null) {
            this.name = String.valueOf(this.name) + "_" + this.svf.toString() + "_" + this.match.toString();
        }
    }

    @Override
    public Value applyFunction(ArrayList<Value> s) {
        int count = 0;
        for (Value v : s) {
            if (!this.match.equals(v)) continue;
            ++count;
        }
        return new Value((double)count / (double)s.size());
    }

    @Override
    public Supplier<Couple<Mutable<Long>, Mutable<Long>>> supplier() {
        return () -> new Couple<Mutable<Long>, Mutable<Long>>(new Mutable<Long>(0L), new Mutable<Long>(0L));
    }

    @Override
    public BiConsumer<Couple<Mutable<Long>, Mutable<Long>>, Value> accumulator() {
        return (accum, val) -> {
            if (val.equals(this.match)) {
                ((Mutable)accum.getLeft()).set((Long)((Mutable)accum.getLeft()).get() + 1L);
            }
            ((Mutable)accum.getRight()).set((Long)((Mutable)accum.getRight()).get() + 1L);
        };
    }

    @Override
    public BinaryOperator<Couple<Mutable<Long>, Mutable<Long>>> combiner() {
        return (a, b) -> {
            ((Mutable)a.getLeft()).set((Long)((Mutable)a.getLeft()).get() + (Long)((Mutable)b.getLeft()).get());
            ((Mutable)a.getRight()).set((Long)((Mutable)a.getRight()).get() + (Long)((Mutable)b.getRight()).get());
            return a;
        };
    }

    @Override
    public Function<Couple<Mutable<Long>, Mutable<Long>>, Value> finisher() {
        return a -> {
            if ((Long)((Mutable)a.getRight()).get() > 0L) {
                return new Value(((Long)((Mutable)a.getLeft()).get()).doubleValue() / ((Long)((Mutable)a.getRight()).get()).doubleValue());
            }
            return new Value(null);
        };
    }
}

