/*
 * Decompiled with CFR 0.152.
 */
package data.condition;

import data.catalog.Catalog;
import data.condition.Condition;
import data.feature.AggregateFeature;
import data.feature.SimpleFeature;
import data.feature.SingleValueFeature;
import data.instance.Instance;
import data.parameter.AffineShift;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import model.inference.ConditionApplication;

public abstract class FilterFeature
implements Condition {
    protected SingleValueFeature feature;
    protected NumericShiftFunction shift;

    public FilterFeature() {
        this.shift = new AffineShift();
    }

    public FilterFeature(NumericShiftFunction sh) {
        this.shift = sh;
    }

    public SingleValueFeature getFeature() {
        return this.feature;
    }

    public void setFeature(SingleValueFeature f) {
        this.feature = f;
    }

    @Override
    public abstract FilterFeature cloneCondition();

    @Override
    public double complexity() {
        return this.feature.complexity();
    }

    @Override
    public HashMap<NumericShiftFunction, double[]> getShifts(ArrayList<Value> vals, Catalog cat) {
        HashMap<NumericShiftFunction, double[]> res = new HashMap<NumericShiftFunction, double[]>();
        if (this.feature instanceof AggregateFeature) {
            res.putAll(((AggregateFeature)this.feature).getShifts(vals, cat));
        }
        return res;
    }

    public NumericShiftFunction getShift() {
        return this.shift;
    }

    public abstract ConditionApplication apply(Instance var1, Catalog var2);

    @Override
    public void initShifts(ArrayList<Value> vals, Catalog cat) {
        if (this.feature instanceof AggregateFeature) {
            ((AggregateFeature)this.feature).initShifts(vals, cat);
        }
    }

    @Override
    public void deployShifts(ArrayList<Value> vals, Catalog cat) {
        if (this.feature instanceof AggregateFeature) {
            ((AggregateFeature)this.feature).deployShifts(vals, cat);
        } else if (this.feature instanceof SimpleFeature) {
            ((SimpleFeature)this.feature).deployShifts(vals, cat);
        }
    }

    @Override
    public HashSet<NumericShiftFunction> getShifts() {
        HashSet<NumericShiftFunction> res = new HashSet<NumericShiftFunction>();
        res.addAll(this.feature.getShifts());
        return res;
    }
}

