/*
 * Decompiled with CFR 0.152.
 */
package measures.classification;

import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import measures.Measure;

public abstract class MeasureBase
extends Measure {
    public abstract double impurity(double var1);

    public double scoreForOnePartition(ArrayList<Instance> ex) {
        HashMap<Value, Integer> repartition = new HashMap<Value, Integer>();
        int total = ex.size();
        for (Instance inst : ex) {
            if (!repartition.containsKey(inst.getLabel())) {
                repartition.put(inst.getLabel(), 0);
            }
            repartition.put(inst.getLabel(), (Integer)repartition.get(inst.getLabel()) + 1);
        }
        double res = 0.0;
        if (total > 0) {
            for (Integer k : repartition.values()) {
                double p = (double)k.intValue() / (double)total;
                res += this.impurity(p);
            }
        }
        return res;
    }

    @Override
    public double score(ArrayList<Instances> examplesPartitioned) {
        ArrayList<Instance> examplesWhole = new ArrayList<Instance>();
        int totalWhole = 0;
        double res = 0.0;
        for (ArrayList arrayList : examplesPartitioned) {
            examplesWhole.addAll(arrayList);
            if (!arrayList.isEmpty()) {
                res -= (double)arrayList.size() * this.scoreForOnePartition(arrayList);
            }
            totalWhole += arrayList.size();
        }
        res /= (double)totalWhole;
        return res += this.scoreForOnePartition(examplesWhole);
    }
}

