/*
 * Decompiled with CFR 0.152.
 */
package model;

import data.aggregate.AggregateFunction;
import data.feature.AggregateFeature;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import measures.Measure;
import measures.classification.Gain;
import measures.classification.GainRatio;
import measures.classification.Gini;
import measures.classification.GiniSquared;
import measures.classification.MinClass;
import measures.regression.StandardDeviation;
import measures.regression.Variance;
import model.DiscretizeScheme;
import model.inference.hc.HillClimbingKind;
import org.apache.commons.cli.CommandLine;

public class ModelOptions {
    public String name = "";
    public int instPerLeaf = 1;
    public boolean pruning = false;
    public int crossValidation = 0;
    public String classPredicate = "";
    public int classArgument = 0;
    public Measure m = new Gain();
    public ArrayList<DiscretizeScheme> toDiscretize = new ArrayList();
    public ArrayList<String> numericTypes = new ArrayList();
    public ArrayList<AggregateFunction<?>> aggFunctions = new ArrayList();
    public int beamSize = 1;
    public String mode = "classification";
    public double stdFactor = 0.0;
    public long seed = 0L;
    public int treesInForest = 1;
    public boolean weightedVoting = false;
    public boolean featureElimination = false;
    public boolean complexity = false;
    public String reframeMethod = "rrs";
    public HillClimbingKind hcKind = HillClimbingKind.GREEDY;

    public ModelOptions() {
    }

    public ModelOptions(CommandLine cmd) {
        this.classPredicate = cmd.getOptionValue("ta");
        if (cmd.hasOption("e") && cmd.getOptionValues("e")[0].equals("cv")) {
            this.crossValidation = new Integer(cmd.getOptionValues("e")[1]);
        }
        if (cmd.hasOption("l")) {
            this.instPerLeaf = new Integer(cmd.getOptionValue("l"));
        }
        if (cmd.hasOption("s")) {
            this.seed = new Long(cmd.getOptionValue("s"));
        }
        if (cmd.hasOption("n")) {
            this.name = cmd.getOptionValue("n");
        }
        if (cmd.hasOption("f")) {
            this.treesInForest = new Integer(cmd.getOptionValue("f"));
        }
        if (cmd.hasOption("h")) {
            String heur = cmd.getOptionValue("h");
            if (heur.equals("rrhcca")) {
                this.hcKind = HillClimbingKind.GREEDY;
            } else if (heur.equals("random")) {
                this.hcKind = HillClimbingKind.RANDOM;
            } else if (heur.equals("global")) {
                this.hcKind = HillClimbingKind.GLOBAL;
            }
        }
        if (cmd.hasOption("r")) {
            this.reframeMethod = cmd.getOptionValues("r")[0];
        }
        if (cmd.hasOption("a")) {
            String[] aggFuns = cmd.getOptionValues("a");
            int i = 0;
            while (i < aggFuns.length) {
                this.aggFunctions.add(AggregateFunction.aggregateFunctionByName(aggFuns[i]));
                ++i;
            }
        }
    }

    public String toString() {
        String res = new String();
        res = String.valueOf(res) + "Minimal leaf size : " + this.instPerLeaf + "\n";
        res = String.valueOf(res) + "Pruning : " + this.pruning + "\n";
        res = this.crossValidation < 2 ? String.valueOf(res) + "No cross-validation\n" : String.valueOf(res) + "Cross-validation with " + this.crossValidation + " folds\n";
        return res;
    }

    public ModelOptions clone() {
        ModelOptions res = new ModelOptions();
        res.name = this.name;
        res.instPerLeaf = this.instPerLeaf;
        res.pruning = this.pruning;
        res.crossValidation = this.crossValidation;
        res.classPredicate = this.classPredicate;
        res.classArgument = this.classArgument;
        res.toDiscretize = new ArrayList();
        int i = 0;
        while (i < this.toDiscretize.size()) {
            res.toDiscretize.add(this.toDiscretize.get(i).clone());
            ++i;
        }
        res.m = this.m;
        res.beamSize = this.beamSize;
        res.numericTypes = this.numericTypes;
        res.aggFunctions = this.aggFunctions;
        res.mode = this.mode;
        res.stdFactor = this.stdFactor;
        res.treesInForest = this.treesInForest;
        res.weightedVoting = this.weightedVoting;
        res.featureElimination = this.featureElimination;
        res.complexity = this.complexity;
        res.hcKind = this.hcKind;
        res.seed = this.seed;
        res.reframeMethod = this.reframeMethod;
        return res;
    }

    public void chooseMetric(String metr) {
        if (metr.equals("gain")) {
            this.m = new Gain();
        } else if (metr.equals("gainratio")) {
            this.m = new GainRatio();
        } else if (metr.equals("gini")) {
            this.m = new Gini();
        } else if (metr.equals("ginisquared")) {
            this.m = new GiniSquared();
        } else if (metr.equals("minclass")) {
            this.m = new MinClass();
        } else if (metr.equals("variance")) {
            this.m = new Variance();
        } else if (metr.equals("stdev")) {
            this.m = new StandardDeviation();
        }
    }

    public static ModelOptions getOptions(String filePath) throws IOException {
        int c;
        ModelOptions res = new ModelOptions();
        FileReader fr = new FileReader(String.valueOf(filePath) + ".opt");
        StringBuffer optContent = new StringBuffer();
        while ((c = fr.read()) != -1) {
            optContent.append((char)c);
        }
        fr.close();
        String cont = new String(optContent);
        String[] lines = cont.split("\n");
        int i = 0;
        while (i < lines.length) {
            if (!lines[i].isEmpty() && lines[i].charAt(0) != '#') {
                String[] temp1 = lines[i].split("\\(");
                String option = temp1[0];
                String[] temp2 = temp1[1].split("\\)");
                String[] arguments = temp2[0].split(",");
                if (option.equals("class")) {
                    res.classPredicate = arguments[0];
                    res.classArgument = Integer.parseInt(arguments[1]);
                } else if (option.equals("pruning")) {
                    res.pruning = Boolean.parseBoolean(arguments[0]);
                } else if (option.equals("min_leaf_size")) {
                    res.instPerLeaf = Integer.parseInt(arguments[0]);
                } else if (option.equals("use_cross_validation")) {
                    res.crossValidation = Integer.parseInt(arguments[0]);
                } else if (option.equals("beam")) {
                    res.beamSize = Integer.parseInt(arguments[0]);
                } else if (option.equals("discretize")) {
                    DiscretizeScheme dopt = new DiscretizeScheme(arguments[0], Integer.parseInt(arguments[1]), Boolean.parseBoolean(arguments[2]));
                    res.toDiscretize.add(dopt);
                } else if (option.equals("metric")) {
                    res.chooseMetric(arguments[0]);
                } else if (option.equals("numeric")) {
                    res.numericTypes.add(arguments[0]);
                } else if (option.equals("aggFunction")) {
                    res.aggFunctions.add(AggregateFunction.aggregateFunctionByName(arguments[0]));
                } else if (option.equals("mode")) {
                    res.mode = arguments[0];
                } else if (option.equals("stdFactor")) {
                    res.stdFactor = Double.parseDouble(arguments[0]);
                } else if (option.equals("forest")) {
                    res.treesInForest = Integer.parseInt(arguments[0]);
                    res.weightedVoting = Boolean.parseBoolean(arguments[1]);
                    res.featureElimination = Boolean.parseBoolean(arguments[2]);
                } else if (option.equals("complexity")) {
                    res.complexity = Boolean.parseBoolean(arguments[0]);
                } else if (option.equals("aggregateComplexityLog")) {
                    AggregateFeature.complexityBase = Math.log(Double.parseDouble(arguments[0]));
                } else if (option.equals("heuristic")) {
                    if (arguments[0].equals("rrhcca")) {
                        res.hcKind = HillClimbingKind.GREEDY;
                    } else if (arguments[0].equals("random")) {
                        res.hcKind = HillClimbingKind.RANDOM;
                    } else if (arguments[0].equals("global")) {
                        res.hcKind = HillClimbingKind.GLOBAL;
                    }
                } else if (option.equals("seed")) {
                    res.seed = Long.parseLong(arguments[0]);
                } else if (option.equals("reframe")) {
                    res.reframeMethod = arguments[0];
                }
            }
            ++i;
        }
        return res;
    }
}

