/*
 * Decompiled with CFR 0.152.
 */
package model.inference.hc;

import data.Type;
import data.aggregate.AggregateFunction;
import data.aggregate.Ratio;
import data.aggregate.selection.SelectionWithFilters;
import data.catalog.Catalog;
import data.condition.FilterFeature;
import data.feature.AggregateFeature;
import data.feature.LinkFeature;
import data.feature.SimpleFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import java.util.stream.Collectors;
import model.ModelOptions;
import model.NodeSplit;
import model.criterion.cancel.CancelCriterion;
import model.inference.hc.AggregateBase;
import model.inference.hc.HillClimbing;
import util.Logging;

public class HillClimbingGlobal
extends HillClimbing {
    private int numIterations = 0;
    private int numIterationsWithoutImp;
    private ArrayList<AggregateBase> abs;
    private AggregateFeature aggregate;
    private ArrayList<SimpleFeature> allFeatures;
    private ArrayList<SimpleFeature> presentFeatures;
    private ArrayList<SimpleFeature> absentFeatures;

    public HillClimbingGlobal(ModelOptions opt, Random gr) {
        super(opt, gr);
    }

    @Override
    public NodeSplit run(Instances insts, Catalog cat, ArrayList<CancelCriterion> cancels) {
        this.abs = new ArrayList();
        Type ti = cat.getClassFeature().getTypeIn();
        ArrayList<LinkFeature> lfs = cat.getLinkFeatures(ti);
        if (!lfs.isEmpty()) {
            LinkFeature lf = lfs.get(0);
            ArrayList<SimpleFeature> sfs = cat.getSimpleFeatures(lf.getTypeOut());
            for (AggregateFunction<?> af : this.opts.aggFunctions) {
                if (af.isNeedsFeature()) {
                    for (SimpleFeature sf : sfs) {
                        if (af.getKindIn() != sf.getTypeOut().getKind()) continue;
                        if (af.getName().equals("ratio")) {
                            for (Value val : sf.getTypeOut().getValues()) {
                                AggregateBase ab = new AggregateBase(new Ratio(sf, val), lf, sf);
                                this.abs.add(ab);
                            }
                            continue;
                        }
                        AggregateBase ab = new AggregateBase(af, lf, sf);
                        this.abs.add(ab);
                    }
                    continue;
                }
                AggregateBase ab = new AggregateBase(af, lf, null);
                this.abs.add(ab);
            }
            if (this.opts.treesInForest > 1) {
                Collections.shuffle(this.abs, this.rt);
                int toKeep = (int)Math.floor(Math.sqrt(this.abs.size()));
                int n = this.abs.size();
                int i = n - 1;
                while (i >= toKeep) {
                    this.abs.remove(i);
                    --i;
                }
            }
            if (this.opts.treesInForest > 1) {
                ArrayList<SimpleFeature> sfsCopy = new ArrayList<SimpleFeature>(sfs);
                Collections.shuffle(sfsCopy, this.rt);
                this.allFeatures = new ArrayList<SimpleFeature>(sfsCopy.subList(0, (1 + sfsCopy.size()) / 2));
            } else {
                this.allFeatures = new ArrayList<SimpleFeature>(sfs);
            }
            this.absentFeatures = new ArrayList<SimpleFeature>(this.allFeatures);
            this.presentFeatures = new ArrayList();
            long numSec = 0L;
            for (Instance inst : insts) {
                numSec += (long)lf.getLinkedElements(inst.getId(), cat).size();
            }
            this.numIterations = (int)Math.round(Math.sqrt((double)this.allFeatures.size() * (double)numSec));
            this.numIterationsWithoutImp = (int)Math.round((double)this.numIterations / 5.0);
        }
        ArrayList<NodeSplit> bestSplits = new ArrayList<NodeSplit>();
        ArrayList<Value> ids = new ArrayList<Value>();
        for (Instance inst : insts) {
            ids.add(inst.getId());
        }
        for (AggregateBase ab : this.abs) {
            AggregateFeature aggFeat = new AggregateFeature(ab.getFunction());
            aggFeat.setFeature(ab.getFeature());
            SelectionWithFilters swf = new SelectionWithFilters();
            swf.setSelection(ab.getLink());
            aggFeat.addToObjectSelection(swf);
            if (this.aggregate == null) {
                this.aggregate = aggFeat.clone();
            }
            this.evaluateAggregate(aggFeat, insts, cat, true, bestSplits, cancels);
        }
        int countSinceLastImprovement = -1;
        int i = 0;
        while (i < this.numIterations && countSinceLastImprovement < this.numIterationsWithoutImp) {
            boolean imp;
            long t1 = System.currentTimeMillis();
            AggregateFeature copyAgg = this.aggregate.clone();
            SimpleFeature sfToModify = this.allFeatures.get(this.rt.nextInt(this.allFeatures.size()));
            boolean improved = false;
            if (this.absentFeatures.contains(sfToModify)) {
                if (sfToModify.getTypeOut().getKind() == 0) {
                    AggregateFeature toTry = copyAgg.clone();
                    toTry.addCondition(cat, sfToModify, new ArrayList<Value>(sfToModify.getTypeOut().getValues()), this.rt);
                    for (AggregateBase ab : this.abs) {
                        toTry.setFunction(ab.getFunction());
                        toTry.setFeature(ab.getFeature());
                        boolean imp2 = this.evaluateAggregate(toTry, insts, cat, true, bestSplits, cancels);
                        if (imp2) {
                            this.aggregate = toTry.clone();
                        }
                        boolean bl = improved = improved || imp2;
                    }
                } else if (sfToModify.getTypeOut().getKind() == 1) {
                    SelectionWithFilters swfCurrent = copyAgg.getObjectSelection().getSelections().get(0).clone();
                    ArrayList secIds = new ArrayList(ids.stream().flatMap(v -> swfCurrent.select((Value)v, cat)).collect(Collectors.toList()));
                    TreeSet<Iterator<AggregateBase>> possibleValues = new TreeSet<Iterator<AggregateBase>>();
                    int maxSize = sfToModify.getTypeOut().getValues().size();
                    for (Value sid : secIds) {
                        if (possibleValues.size() >= maxSize) break;
                        Value valueForInput = sfToModify.result(sid, cat);
                        if (valueForInput.getStringValue() == null) continue;
                        possibleValues.add((Iterator<AggregateBase>)((Object)valueForInput));
                    }
                    AggregateFeature toTry = copyAgg.clone();
                    toTry.addCondition(cat, sfToModify, new ArrayList<Value>(possibleValues), this.rt);
                    for (AggregateBase ab : this.abs) {
                        toTry.setFunction(ab.getFunction());
                        toTry.setFeature(ab.getFeature());
                        imp = this.evaluateAggregate(toTry, insts, cat, true, bestSplits, cancels);
                        if (imp) {
                            this.aggregate = toTry.clone();
                        }
                        boolean bl = improved = improved || imp;
                    }
                }
            } else if (this.presentFeatures.contains(sfToModify)) {
                if (sfToModify.getTypeOut().getKind() == 0) {
                    AggregateFeature toTry = copyAgg.clone();
                    ArrayList<Value> valuesAttr = new ArrayList<Value>(sfToModify.getTypeOut().getValues());
                    toTry.applyMove(cat, ids, sfToModify, valuesAttr.get(this.rt.nextInt(valuesAttr.size())));
                    for (AggregateBase ab : this.abs) {
                        toTry.setFunction(ab.getFunction());
                        toTry.setFeature(ab.getFeature());
                        boolean imp3 = this.evaluateAggregate(toTry, insts, cat, toTry.complexity() >= copyAgg.complexity(), bestSplits, cancels);
                        if (imp3) {
                            this.aggregate = toTry.clone();
                        }
                        boolean bl = improved = improved || imp3;
                    }
                } else if (sfToModify.getTypeOut().getKind() == 1) {
                    SelectionWithFilters swfClone = copyAgg.getObjectSelection().getSelections().get(0).clone();
                    FilterFeature toRemove = null;
                    for (FilterFeature ff : swfClone.getFilters()) {
                        if (!ff.getFeature().equals(sfToModify)) continue;
                        toRemove = ff;
                        break;
                    }
                    if (toRemove != null) {
                        swfClone.getFilters().remove(toRemove);
                    }
                    ArrayList secIds = new ArrayList(ids.stream().flatMap(v -> swfClone.select((Value)v, cat)).collect(Collectors.toList()));
                    TreeSet<Value> possibleValues = new TreeSet<Value>();
                    int maxSize = sfToModify.getTypeOut().getValues().size();
                    for (Value sid : secIds) {
                        if (possibleValues.size() >= maxSize) break;
                        Value valueForInput = sfToModify.result(sid, cat);
                        if (valueForInput.getStringValue() == null) continue;
                        possibleValues.add(valueForInput);
                    }
                    if (!possibleValues.isEmpty()) {
                        AggregateFeature toTry = copyAgg.getNeighbor(possibleValues, sfToModify, this.rt);
                        for (AggregateBase ab : this.abs) {
                            toTry.setFunction(ab.getFunction());
                            toTry.setFeature(ab.getFeature());
                            boolean imp4 = this.evaluateAggregate(toTry, insts, cat, toTry.complexity() >= copyAgg.complexity(), bestSplits, cancels);
                            if (imp4) {
                                this.aggregate = toTry.clone();
                            }
                            boolean bl = improved = improved || imp4;
                        }
                    }
                }
            }
            if (improved) {
                countSinceLastImprovement = -1;
                boolean simplification = true;
                while (simplification) {
                    simplification = false;
                    this.presentFeatures.clear();
                    this.absentFeatures.clear();
                    for (FilterFeature ff : this.aggregate.getObjectSelection().getSelections().get(0).getFilters()) {
                        this.presentFeatures.add((SimpleFeature)ff.getFeature());
                    }
                    for (SimpleFeature sf : this.allFeatures) {
                        boolean isPresent = this.presentFeatures.contains(sf);
                        if (isPresent) continue;
                        this.absentFeatures.add(sf);
                    }
                    AggregateFeature copyAggSimpl = this.aggregate.clone();
                    for (SimpleFeature sf : this.presentFeatures) {
                        AggregateFeature toTry = copyAggSimpl.clone();
                        toTry.removeCondition(sf);
                        for (AggregateBase ab : this.abs) {
                            toTry.setFunction(ab.getFunction());
                            toTry.setFeature(ab.getFeature());
                            imp = this.evaluateAggregate(toTry, insts, cat, toTry.complexity() >= copyAgg.complexity(), bestSplits, cancels);
                            if (imp) {
                                this.aggregate = toTry.clone();
                            }
                            boolean bl = simplification = simplification || imp;
                        }
                    }
                }
                Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - " + "New best aggregate!\n" + bestSplits.get(0).toString()));
            }
            this.presentFeatures.clear();
            this.absentFeatures.clear();
            for (FilterFeature ff : this.aggregate.getObjectSelection().getSelections().get(0).getFilters()) {
                this.presentFeatures.add((SimpleFeature)ff.getFeature());
            }
            for (SimpleFeature sf : this.allFeatures) {
                boolean isPresent = this.presentFeatures.contains(sf);
                if (isPresent) continue;
                this.absentFeatures.add(sf);
            }
            long t2 = System.currentTimeMillis();
            Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - " + i + "/" + this.numIterations + "\t" + (double)(t2 - t1) / 1000.0 + "s.\t" + ++countSinceLastImprovement + "/" + this.numIterationsWithoutImp));
            ++i;
        }
        Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - HC finished. Best split(s) :\n" + bestSplits.toString()));
        return this.chooseBestSplit(bestSplits);
    }
}

