/*
 * Decompiled with CFR 0.152.
 */
package model.tree;

import data.catalog.Catalog;
import data.feature.SimpleFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import model.Model;
import model.ModelOptions;
import model.inference.hc.AggregateBase;
import model.tree.RandomForest;
import model.tree.RestrictedRandomForest;
import org.jdom2.Element;
import util.FileWrite;

public class FeatureEliminationRandomForest
extends Model {
    protected double oob;
    protected RandomForest model;

    public FeatureEliminationRandomForest(ModelOptions opts2) {
        this.opts = opts2;
    }

    public FeatureEliminationRandomForest(ModelOptions opts2, RandomForest model2) {
        this(opts2);
        this.model = model2;
    }

    @Override
    public void build(Instances instsTrain, Catalog cat) {
        RandomForest rf = new RandomForest(this.opts.clone());
        rf.addToName("_main");
        rf.build(instsTrain, cat);
        FileWrite.writeToFile(rf.name(), rf.toString());
        try {
            HashMap<SimpleFeature, Double> mainFeatScores = rf.mainFeatureImportance(cat);
            HashMap<AggregateBase, Double> aggScores = rf.aggregateProcessImportance(cat);
            TreeMap rankedAggs = new TreeMap();
            for (Map.Entry<AggregateBase, Double> ent : aggScores.entrySet()) {
                if (!rankedAggs.containsKey(ent.getValue())) {
                    rankedAggs.put(ent.getValue(), new ArrayList());
                }
                ((ArrayList)rankedAggs.get(ent.getValue())).add(ent.getKey());
            }
            TreeMap rankedMainFeats = new TreeMap();
            for (Map.Entry<SimpleFeature, Double> ent : mainFeatScores.entrySet()) {
                if (!rankedMainFeats.containsKey(ent.getValue())) {
                    rankedMainFeats.put(ent.getValue(), new ArrayList());
                }
                ((ArrayList)rankedMainFeats.get(ent.getValue())).add(ent.getKey());
            }
            ArrayList mfToUse = new ArrayList();
            ArrayList aggsToUse = new ArrayList();
            int numFeats = 0;
            RestrictedRandomForest bestModel = null;
            double bestScore = -1.7976931348623157E308;
            while (!rankedMainFeats.isEmpty() || !rankedAggs.isEmpty()) {
                ArrayList mfToAdd;
                double bestAggSc;
                double bestMfSc = rankedMainFeats.isEmpty() ? -1.7976931348623157E308 : (Double)rankedMainFeats.lastKey();
                double d = bestAggSc = rankedAggs.isEmpty() ? -1.7976931348623157E308 : (Double)rankedAggs.lastKey();
                if (bestMfSc > bestAggSc) {
                    mfToAdd = (ArrayList)rankedMainFeats.remove(rankedMainFeats.lastKey());
                    numFeats += mfToAdd.size();
                    mfToUse.addAll(mfToAdd);
                } else if (bestMfSc < bestAggSc) {
                    ArrayList aggsToAdd = (ArrayList)rankedAggs.remove(rankedAggs.lastKey());
                    numFeats += aggsToAdd.size();
                    aggsToUse.addAll(aggsToAdd);
                } else {
                    mfToAdd = (ArrayList)rankedMainFeats.remove(rankedMainFeats.lastKey());
                    numFeats += mfToAdd.size();
                    mfToUse.addAll(mfToAdd);
                    ArrayList aggsToAdd = (ArrayList)rankedAggs.remove(rankedAggs.lastKey());
                    numFeats += aggsToAdd.size();
                    aggsToUse.addAll(aggsToAdd);
                }
                RestrictedRandomForest rrf = new RestrictedRandomForest(this.opts.clone(), new ArrayList<SimpleFeature>(mfToUse), new ArrayList<AggregateBase>(aggsToUse));
                rrf.addToName("_rrf_" + numFeats);
                rrf.build(instsTrain, cat);
                FileWrite.writeToFile(rrf.name(), rrf.toString());
                double score = rrf.oob;
                FileWrite.writeToFile(String.valueOf(this.name()) + "_score", String.valueOf(numFeats) + ";" + score + "\n");
                if (!(score > bestScore)) continue;
                bestModel = rrf;
                bestScore = score;
            }
            this.model = bestModel;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        if (this.model == null) {
            this.model = new RandomForest(this.opts.clone());
            this.model.build(instsTrain, cat);
        }
        this.model.addToName("_final");
        this.initShifts(instsTrain, cat);
    }

    @Override
    public HashMap<NumericShiftFunction, double[]> getShifts(Instances insts, Catalog cat) {
        return this.model.getShifts(insts, cat);
    }

    @Override
    public Value classify(Instance inst, Catalog cat) {
        return this.model.classify(inst, cat);
    }

    @Override
    public Model clone() {
        FeatureEliminationRandomForest res = null;
        res = this.model == null ? new FeatureEliminationRandomForest(this.opts.clone()) : new FeatureEliminationRandomForest(this.opts.clone(), (RandomForest)this.model.clone());
        return res;
    }

    @Override
    public String toString() {
        return this.model.toString();
    }

    @Override
    public String name() {
        return this.opts.name;
    }

    @Override
    public HashSet<NumericShiftFunction> getParameters() {
        return null;
    }

    @Override
    public void addToName(String string) {
        this.opts.name = String.valueOf(this.opts.name) + string;
    }

    @Override
    public Element toXMLElement() {
        return this.model.toXMLElement();
    }

    @Override
    public void initShifts(Instances insts, Catalog cat) {
        this.model.initShifts(insts, cat);
    }

    @Override
    public void deployShifts(Instances insts, Catalog cat) {
        this.model.deployShifts(insts, cat);
    }

    @Override
    public HashSet<NumericShiftFunction> getShifts() {
        return this.model.getShifts();
    }
}

