/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;

public class SortedList<E>
extends AbstractList<E> {
    private ArrayList<E> internalList = new ArrayList();
    private Comparator<E> comparator;

    public SortedList() {
    }

    public SortedList(Comparator<E> comp) {
        this();
        this.comparator = comp;
    }

    @Override
    public E get(int index) {
        return this.internalList.get(index);
    }

    @Override
    public int size() {
        return this.internalList.size();
    }

    @Override
    public boolean add(E elem) {
        if (elem == null) {
            return false;
        }
        if (this.internalList.isEmpty()) {
            this.internalList.add(elem);
        } else {
            int l = 0;
            int r = this.internalList.size() - 1;
            while (l < r) {
                int m = (l + r) / 2;
                int c = this.comparator.compare(elem, this.internalList.get(m));
                if (c < 0) {
                    r = m;
                    continue;
                }
                if (c <= 0) break;
                l = m + 1;
            }
            this.internalList.add((l + r) / 2, elem);
        }
        return true;
    }

    @Override
    public E remove(int pos) {
        return this.internalList.remove(pos);
    }
}

