/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import proper.core.ArgumentObject;
import proper.core.CommandLineInterface;
import proper.engine.Engine;
import proper.io.CommandLine;
import proper.io.CommandLineParameter;
import proper.util.ProperVector;
import proper.util.Stopwatch;
import proper.util.Strings;
import proper.xml.Attribute;
import proper.xml.Element;
import proper.xml.XMLAccessInterface;

public abstract class Application
extends ArgumentObject
implements CommandLineInterface,
XMLAccessInterface {
    protected CommandLine cl = new CommandLine();
    protected Stopwatch watch = new Stopwatch();
    protected int indention = 1;
    protected Vector parameters = new ProperVector();
    protected Vector notes = new ProperVector();

    public Application() {
        this.defaultParameters();
        this.defineParameters();
        this.setDefinitions(this.cl);
    }

    public static Application createInstance(String classname) {
        Application result;
        try {
            Class<?> cls = Class.forName(classname);
            result = (Application)cls.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    protected void addDefinition(String name, String description, boolean hasArgument, String argDesc, boolean optional) {
        CommandLineParameter p = new CommandLineParameter(name, description, hasArgument, argDesc, optional);
        p.setIndention(this.indention);
        this.parameters.add(p);
    }

    protected void addNote(String note) {
        this.notes.add(note);
    }

    protected void defaultParameters() {
    }

    protected void defineParameters() {
        this.addDefinition("verbose", "sets the verbose flag of the specified class(es), 'all' matches them all", true, "class[,class[,..]]", true);
        this.addDefinition("log", "redirects the output into the specified file", true, "<filename>", true);
        this.addDefinition("append_log", "with this the file is not deleted at the beginning", true, "yes | no", true);
        this.addDefinition("help", "to print this help", false, "", true);
    }

    protected void setDefinitions(CommandLine cl) {
        cl.clearParameterDefinitions();
        int i = 0;
        while (i < this.parameters.size()) {
            cl.addParameterDefinition((CommandLineParameter)this.parameters.get(i));
            ++i;
        }
    }

    @Override
    public void checkCommandLine() {
        if (this.cl.exists("help")) {
            this.printUsage();
            System.exit(0);
        }
        if (!this.cl.isComplete()) {
            this.parameterError();
        }
    }

    @Override
    public void parameterError() {
        int i;
        this.printUsage();
        if (this.cl.getMissing().size() > 0) {
            System.out.println("The following parameter(s) are missing:");
            i = 0;
            while (i < this.cl.getMissing().size()) {
                System.out.println(" -" + this.cl.getMissing().get(i));
                ++i;
            }
            System.out.println();
        }
        if (this.cl.getErroneous().size() > 0) {
            System.out.println("The following parameter(s) are incorrect:");
            i = 0;
            while (i < this.cl.getErroneous().size()) {
                System.out.println(" -" + this.cl.getErroneous().get(i));
                ++i;
            }
            System.out.println();
        }
        System.exit(1);
    }

    @Override
    public void printDescription() {
    }

    @Override
    public void printUsage() {
        System.out.println("\n" + this.getClass().getName() + "\n" + this.getClass().getName().replaceAll(".", "=") + "\n");
        this.printDescription();
        System.out.println("Parameters:\n");
        int i = 0;
        while (i < this.parameters.size()) {
            System.out.println(this.parameters.get(i) + "\n");
            ++i;
        }
        if (this.notes.size() > 0) {
            System.out.println("Notes:\n");
            i = 0;
            while (i < this.notes.size()) {
                Vector lines = Strings.breakUpVector(this.notes.get(i).toString(), "\n");
                int n = 0;
                while (n < lines.size()) {
                    System.out.println(String.valueOf(Strings.stringOf(" ", this.indention)) + lines.get(n).toString());
                    ++n;
                }
                System.out.println();
                ++i;
            }
        }
    }

    protected void initEngine(Engine engine) {
        this.addListener(engine);
        if (!engine.getVerbose()) {
            engine.setVerbose(this.getVerbose());
        }
    }

    protected boolean initialize(String[] args) throws Exception {
        this.setArgs(args);
        if (this.cl.exists("verbose")) {
            this.setVerboseString(this.cl.getValue("verbose"));
        }
        if (this.cl.exists("log") && !this.cl.getValue("log").equals("")) {
            System.out.println("Output is redirected to '" + this.cl.getValue("log") + "'...");
            this.addOutput(new PrintStream(new BufferedOutputStream(new FileOutputStream(this.cl.getValue("log"), this.cl.getValue("append_log").equals("yes")))));
        }
        return true;
    }

    protected boolean process() throws Exception {
        return true;
    }

    public void setArgs(String[] args) {
        if (args == null) {
            this.cl.setArguments(new String[0]);
        } else {
            this.cl.setArguments(args);
        }
        this.checkCommandLine();
    }

    @Override
    public void setArgs(CommandLine cl) {
        this.setArgs(cl.toArray());
    }

    public boolean run() throws Exception {
        return this.run(this.cl.toArray());
    }

    @Override
    public boolean run(String[] args) throws Exception {
        boolean result = this.initialize(args);
        if (result) {
            this.println(this);
            this.watch.start();
            result = this.process();
            this.watch.stop();
            this.println("\nRuntime: " + this.watch.getSeconds() + "s");
        }
        return result;
    }

    @Override
    public String toString() {
        String result = String.valueOf(this.getClass().getName()) + ":";
        Vector params = this.cl.getParameters();
        int i = 0;
        while (i < params.size()) {
            String param = (String)params.get(i);
            result = String.valueOf(result) + " -" + param;
            if (!this.cl.getValue(param).equals("")) {
                result = String.valueOf(result) + " \"" + this.cl.getValue(param) + "\"";
            }
            ++i;
        }
        return result;
    }

    @Override
    public Element toXML() {
        Element result = new Element("java");
        result.addAttribute(new Attribute("classname", this.getClass().getName()));
        result.addAttribute(new Attribute("fork", "yes"));
        Element node = this.cl.toXML();
        int i = 0;
        while (i < node.getChildCount()) {
            result.add((Element)node.getChildAt(i));
            ++i;
        }
        return result;
    }

    @Override
    public void fromXML(Element node) {
        this.cl.fromXML(node);
    }
}

