/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import java.util.Vector;
import proper.app.DatabaseApplication;
import proper.database.Column;
import proper.database.ColumnLister;
import proper.database.Connector;
import proper.database.Executor;
import proper.database.TableLister;

public class Reducer
extends DatabaseApplication {
    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("column", "the column the deleting is based on", true, "<name>", false);
        this.addDefinition("from", "the first value of the column to keep (SQL wildcards are allowed)", true, "<value>", true);
        this.addDefinition("to", "the last value of the column to keep (SQL wildcards the last value of the column to keep (SQL wildcards", true, "<value>", true);
    }

    @Override
    public void checkCommandLine() {
        super.checkCommandLine();
        if (!this.cl.exists("from") && !this.cl.exists("to")) {
            this.parameterError();
        }
    }

    @Override
    public void printDescription() {
        System.out.println("Deletes rows from tables in a database that contain a certain column. The");
        System.out.println("range of rows to keep can be specified.");
        System.out.println();
    }

    private String buildValue(Column col, String value, boolean isFrom) {
        String result = col.toString();
        result = isFrom ? String.valueOf(result) + " < " : String.valueOf(result) + " > ";
        result = col.isNominal() ? String.valueOf(result) + "'" + value + "'" : String.valueOf(result) + value;
        return result;
    }

    @Override
    protected boolean process() throws Exception {
        Connector conn = new Connector(this.cl.getValue("driver"), this.cl.getValue("url"), this.cl.getValue("database"), this.cl.getValue("user"), this.cl.getValue("password"));
        this.addListener(conn);
        Executor exec = new Executor(conn);
        TableLister tab = new TableLister(conn);
        ColumnLister col = new ColumnLister(conn);
        col.setSort(true);
        boolean result = true;
        Vector tables = tab.getList();
        Column column = new Column(this.cl.getValue("column"));
        int i = 0;
        while (i < tables.size()) {
            this.print(tables.get(i) + "... ");
            col.setTable(tables.get(i).toString());
            Vector columns = col.getList();
            if (columns.contains(column)) {
                String sql = "DELETE FROM " + tables.get(i).toString() + " WHERE ";
                if (this.cl.exists("from")) {
                    sql = String.valueOf(sql) + this.buildValue(column, this.cl.getValue("from"), true);
                }
                if (this.cl.exists("from") && this.cl.exists("to")) {
                    sql = String.valueOf(sql) + " AND ";
                }
                if (this.cl.exists("to")) {
                    sql = String.valueOf(sql) + this.buildValue(column, this.cl.getValue("to"), false);
                }
                if (this.getVerbose()) {
                    this.print("\n" + sql + " = ");
                }
                if (result = exec.update(sql)) {
                    this.println("OK");
                } else {
                    this.println("ERROR");
                    this.println(exec.getLastException());
                }
            } else {
                this.println("nothing to do.");
            }
            if (!result) break;
            ++i;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Reducer app = new Reducer();
        app.run(args);
    }
}

