/*
 * Decompiled with CFR 0.152.
 */
package proper.cardinalization;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import proper.database.Column;
import proper.database.Table;

public class CardinalizerTable
extends Table {
    private TreeMap<Column, Boolean> columns;

    public CardinalizerTable() {
        super(null);
        this.columns = new TreeMap();
    }

    public CardinalizerTable(String name) {
        super(name);
        this.columns = new TreeMap();
    }

    public CardinalizerTable(String name, int size) {
        super(name, size);
        this.columns = new TreeMap();
    }

    public CardinalizerTable(CardinalizerTable table) {
        super(table.name, table.size);
        this.columns = table.columns;
    }

    public void addColumn(String name, int type) {
        Column newColumn = new Column(name, type);
        if (!this.columns.containsKey(newColumn)) {
            this.columns.put(newColumn, false);
        }
    }

    public void addColumn(String name, int type, boolean isJoinColumn) {
        Column newColumn = new Column(name, type);
        if (!this.columns.containsKey(newColumn)) {
            this.columns.put(newColumn, isJoinColumn);
        }
    }

    public void addColumn(Column column) {
        if (!this.columns.containsKey(column)) {
            this.columns.put(column, false);
        }
    }

    public void addColumn(Column column, boolean isJoinColumn) {
        if (!this.columns.containsKey(column)) {
            this.columns.put(column, isJoinColumn);
        }
    }

    public Column getColumn(String name) {
        Iterator<Column> elements = this.columns.keySet().iterator();
        Column result = null;
        while (elements.hasNext() && result == null) {
            result = elements.next();
            if (result.getName().equals(name)) continue;
            result = null;
        }
        return result;
    }

    public Column getColumn(int index) {
        Iterator<Column> elements = this.columns.keySet().iterator();
        Column result = null;
        int i = 0;
        while (elements.hasNext() && result == null) {
            result = elements.next();
            if (i != index) {
                result = null;
            }
            ++i;
        }
        return result;
    }

    public Column getJoinColumn() {
        boolean isPk = false;
        Iterator<Column> elements = this.columns.keySet().iterator();
        Column result = null;
        while (elements.hasNext() && !isPk) {
            result = elements.next();
            isPk = this.columns.get(result);
        }
        if (!isPk) {
            result = null;
        }
        return result;
    }

    public boolean isJoinColumn(Column column) {
        boolean result = false;
        if (this.columns.containsKey(column)) {
            result = this.columns.get(column);
        }
        return result;
    }

    public int columnCount() {
        return this.columns.size();
    }

    public void print() {
        System.out.println(this.name);
        int i = 0;
        while (i < this.columnCount()) {
            String printer = "|-" + this.getColumn(i).getName() + " Type : " + this.getColumn(i).typeToString();
            System.out.println(printer);
            ++i;
        }
        System.out.println("\tJoin Column :" + this.getJoinColumn() + "\n");
    }

    public static void main(String[] args) {
        Vector<CardinalizerTable> tables = new Vector<CardinalizerTable>();
        int i = 0;
        while (i < 5) {
            tables.add(new CardinalizerTable("Table" + i, i * 10));
            int j = 0;
            while (j < 5) {
                if (j != 0) {
                    ((CardinalizerTable)tables.get(i)).addColumn("t" + i + "_" + "column" + j, 4);
                } else {
                    ((CardinalizerTable)tables.get(i)).addColumn("t" + i + "_" + "column" + j, 4, true);
                }
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < 5) {
            ((CardinalizerTable)tables.get(k)).print();
            ++k;
        }
    }
}

