/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import proper.database.Column;
import proper.util.ProperVector;

public class ColumnTreeNode
extends DefaultMutableTreeNode {
    public ColumnTreeNode() {
    }

    public ColumnTreeNode(Object o) {
        this.setColumn(o);
    }

    public void setColumn(Object o) {
        if (o instanceof String) {
            this.setUserObject(new Column(o.toString()));
        } else if (o instanceof Column) {
            this.setUserObject(o);
        } else {
            this.setUserObject(null);
        }
    }

    public Column getColumn() {
        return (Column)this.getUserObject();
    }

    public Column getChildColumnAt(int index) {
        return ((ColumnTreeNode)this.getChildAt(index)).getColumn();
    }

    public boolean isInPath(Column c) {
        Vector columns = this.getColumnsAlongPath();
        return columns.indexOf(c) > 1;
    }

    public Vector getColumnsAlongPath() {
        ProperVector result = new ProperVector();
        ColumnTreeNode node = this;
        while (node != null) {
            result.add(node.getColumn());
            node = (ColumnTreeNode)node.getParent();
        }
        return result;
    }

    public Vector getAllNodes() {
        ProperVector result = new ProperVector();
        Enumeration<TreeNode> enm = this.depthFirstEnumeration();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        return result;
    }

    public Vector getAllColumns() {
        ProperVector result = new ProperVector();
        Vector nodes = this.getAllNodes();
        int i = 0;
        while (i < nodes.size()) {
            ColumnTreeNode anode = (ColumnTreeNode)nodes.get(i);
            result.add(anode.getColumn());
            ++i;
        }
        return result;
    }

    private static String getNextStructure(String tree) {
        int commaPos;
        String result = "";
        int bracketPos = tree.indexOf("[");
        if (bracketPos == -1) {
            bracketPos = tree.length();
        }
        if ((commaPos = tree.indexOf(",")) == -1) {
            commaPos = tree.length();
        }
        if (commaPos < bracketPos) {
            result = tree.substring(0, commaPos);
        } else if (bracketPos < commaPos) {
            if (bracketPos > 0) {
                result = tree.substring(0, bracketPos);
            } else {
                int openCount = 0;
                int closeCount = 0;
                int i = 0;
                while (i < tree.length()) {
                    String chr = tree.substring(i, i + 1);
                    result = String.valueOf(result) + chr;
                    if (chr.equals("[")) {
                        ++openCount;
                    }
                    if (chr.equals("]")) {
                        ++closeCount;
                    }
                    if (openCount <= 0 || openCount != closeCount) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            result = tree;
        }
        return result;
    }

    private static ColumnTreeNode createNode(String part) {
        String size;
        String typeName;
        String type;
        String name;
        if (part.indexOf("(") > -1) {
            name = part.substring(0, part.indexOf("("));
            part = part.replaceAll(".*\\(", "").replaceAll("\\)", "");
            type = part.substring(0, part.indexOf(";"));
            part = part.substring(part.indexOf(";") + 1);
            typeName = part.substring(0, part.indexOf(";"));
            size = part.substring(part.indexOf(";") + 1);
        } else {
            name = part;
            type = Integer.toString(1111);
            typeName = "";
            size = "0";
        }
        return new ColumnTreeNode(new Column(name, Integer.parseInt(type), typeName, Integer.parseInt(size)));
    }

    private static ColumnTreeNode parseTreeString(ColumnTreeNode parent, String tree) {
        if (parent == null) {
            String part = ColumnTreeNode.getNextStructure(tree);
            parent = ColumnTreeNode.createNode(part);
            String newTree = tree.substring(part.length() + 1, tree.length() - 1);
            ColumnTreeNode.parseTreeString(parent, newTree);
        } else {
            String newTree = tree;
            while (!newTree.equals("")) {
                String part = ColumnTreeNode.getNextStructure(newTree);
                if ((newTree = newTree.substring(part.length(), newTree.length())).startsWith(",")) {
                    newTree = newTree.substring(1, newTree.length());
                    if (part.equals("")) continue;
                    parent.add(ColumnTreeNode.createNode(part));
                    continue;
                }
                if (newTree.startsWith("[")) {
                    if (!part.equals("")) {
                        parent.add(ColumnTreeNode.createNode(part));
                    }
                    String tmp = ColumnTreeNode.getNextStructure(newTree);
                    ColumnTreeNode.parseTreeString((ColumnTreeNode)parent.getChildAt(parent.getChildCount() - 1), tmp.substring(1, tmp.length() - 1));
                    newTree = newTree.substring(tmp.length(), newTree.length());
                    continue;
                }
                if (part.equals("")) continue;
                parent.add(ColumnTreeNode.createNode(part));
            }
        }
        return parent;
    }

    public static ColumnTreeNode parseTreeString(String tree) {
        return ColumnTreeNode.parseTreeString(null, tree.replaceAll(" ", ""));
    }

    public String toTreeString() {
        return this.toTreeString(false);
    }

    public String toTreeString(boolean include) {
        return ColumnTreeNode.toTreeString(this, include);
    }

    public static String toTreeString(ColumnTreeNode node) {
        return ColumnTreeNode.toTreeString(node, false);
    }

    public static String toTreeString(ColumnTreeNode node, boolean include) {
        StringBuffer result = new StringBuffer(node.getColumn().getName());
        if (include) {
            result.append("(" + node.getColumn().getType() + ";" + node.getColumn().getTypeName() + ";" + node.getColumn().getSize() + ")");
        }
        int i = 0;
        while (i < node.getChildCount()) {
            if (i == 0) {
                result.append("[");
            }
            if (!result.toString().endsWith("[")) {
                result.append(",");
            }
            result.append(ColumnTreeNode.toTreeString((ColumnTreeNode)node.getChildAt(i), include));
            if (i == node.getChildCount() - 1) {
                result.append("]");
            }
            ++i;
        }
        return result.toString();
    }

    private String toString(ColumnTreeNode node, String str) {
        StringBuffer tmp = new StringBuffer(str);
        int i = 0;
        while (i < node.getLevel()) {
            if (i > 0) {
                tmp.append(" ");
            }
            tmp.append("|");
            ++i;
        }
        if (node.getLevel() > 0) {
            tmp.append("-");
        }
        tmp.append(String.valueOf(node.getColumn().toString()) + "\n");
        i = 0;
        while (i < node.getChildCount()) {
            tmp = new StringBuffer(this.toString((ColumnTreeNode)node.getChildAt(i), tmp.toString()));
            ++i;
        }
        return tmp.toString();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean all) {
        if (all) {
            return this.toString(this, "");
        }
        return this.getColumn().toString();
    }
}

