/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.sql.Connection;
import java.sql.DriverManager;
import proper.core.ProperObject;

public class Connector
extends ProperObject {
    public static final String MYSQL_DRIVER = "org.gjt.mm.mysql.Driver";
    public static final String MYSQL_USER = "nobody";
    public static final String MYSQL_PASSWORD = "";
    public static final String MYSQL_URL = "jdbc:mysql://localhost:3306/";
    public static final String ROWS = "%ROWS%";
    public static final String MYSQL_LIMIT = "LIMIT %ROWS%";
    private Connection conn = null;
    private String driver = "a";
    private String url = "";
    private String database = "";
    private String user = "";
    private String password = "";
    private String limit = "LIMIT %ROWS%";
    private String table = "";
    private String column;

    public Connector() throws Exception {
    }

    public Connector(String url, String database) throws Exception {
        this(url, database, MYSQL_USER);
    }

    public Connector(String url, String database, String user) throws Exception {
        this(url, database, user, null);
    }

    public Connector(String url, String database, String user, String password) throws Exception {
        this(MYSQL_DRIVER, url, database, user, password);
    }

    public Connector(String driver, String url, String database, String user, String password) throws Exception {
        this();
        this.connect(driver, url, database, user, password);
    }

    public boolean connect() {
        boolean result;
        String msg = "Connecting to " + this.getUrl() + this.getDatabase() + " as User '" + this.getUser() + "'" + " with Password '" + this.getPassword().replaceAll(".", "*") + "'" + " with Driver '" + this.getDriver() + "'";
        try {
            if (this.isConnected()) {
                this.disconnect();
            }
            Class.forName(this.getDriver());
            String url = this.getUrl();
            if (this.getDatabase() != null) {
                url = String.valueOf(url) + this.getDatabase();
            }
            this.conn = DriverManager.getConnection(url, this.getUser(), this.getPassword());
            result = this.isConnected();
        }
        catch (Exception e) {
            this.println(msg);
            this.println(e);
            result = false;
        }
        if (this.getVerbose()) {
            this.println(String.valueOf(msg) + " = " + result);
        }
        return result;
    }

    public boolean connect(String driver, String url, String database, String user, String password) {
        this.driver = driver.equals(MYSQL_PASSWORD) ? MYSQL_DRIVER : driver;
        this.url = url.equals(MYSQL_PASSWORD) ? MYSQL_URL : url;
        this.user = user.equals(MYSQL_PASSWORD) ? MYSQL_USER : user;
        this.password = password;
        this.database = database;
        return this.connect();
    }

    public void disconnect() throws Exception {
        if (this.isConnected()) {
            this.conn.close();
            this.conn = null;
            if (this.getVerbose()) {
                this.println("Disconnected from " + this.getUrl() + this.getDatabase());
            }
        }
    }

    public boolean isConnected() throws Exception {
        return this.conn != null && !this.conn.isClosed();
    }

    public String getDriver() {
        return this.driver;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String col) {
        this.column = col;
    }

    public void setDatabase(String db) {
        this.database = db;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getLimit() {
        return this.limit;
    }

    public String getLimit(int count) {
        return this.limit.replaceAll(ROWS, Integer.toString(count));
    }

    @Override
    public String toString() {
        String result = "Driver  : " + this.getDriver() + "\n" + "URL     : " + this.getUrl() + "\n" + "Database: " + this.getDatabase() + "\n" + "User    : " + this.getUser() + "\n" + "Password: " + this.getPassword().replaceAll(".", "*") + "\n" + "Table: " + this.getTable() + "\n" + "Column: " + this.getColumn() + "\n" + "Limit   : " + this.getLimit();
        return result;
    }
}

