/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import proper.database.Column;
import proper.database.ColumnLister;
import proper.database.Connector;
import proper.database.ExecutorObject;
import proper.imp.Fingerprint;
import proper.util.ProperVector;
import proper.util.RandomID;

public class Sparser
extends ExecutorObject {
    private HashSet keys = new HashSet();
    private double percentage;
    private String table;
    private String index;
    private String classField;
    private boolean initialized;
    private boolean onlyClassified;
    private boolean onlyUnclassified;
    private Column columnClass;
    private Column columnIndex;
    private double keyRatio;

    public Sparser(Connector conn) {
        super(conn);
        this.clear();
    }

    public void clear() {
        this.keys.clear();
        this.initialized = false;
        this.percentage = 0.0;
        this.table = "";
        this.index = "";
        this.classField = "";
        this.onlyClassified = false;
        this.onlyUnclassified = false;
        this.columnClass = null;
        this.columnIndex = null;
        this.keyRatio = 1.0;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getIndex() {
        return this.index;
    }

    public int getIndexType() {
        if (this.columnIndex == null) {
            this.initializeTypes();
        }
        if (this.columnIndex == null) {
            return 1111;
        }
        return this.columnIndex.getType();
    }

    public void setClassField(String classField) {
        this.classField = classField;
    }

    public String getClassField() {
        return this.classField;
    }

    public int getClassFieldType() {
        if (this.columnClass == null) {
            this.initializeTypes();
        }
        if (this.columnClass == null) {
            return 1111;
        }
        return this.columnClass.getType();
    }

    public void setOnlyClassified(boolean onlyClassified) {
        if (onlyClassified) {
            this.setOnlyUnclassified(false);
        }
        this.onlyClassified = onlyClassified;
    }

    public boolean getOnlyClassified() {
        return this.onlyClassified;
    }

    public void setOnlyUnclassified(boolean onlyUnclassified) {
        if (onlyUnclassified) {
            this.setOnlyClassified(false);
        }
        this.onlyUnclassified = onlyUnclassified;
    }

    public boolean getOnlyUnclassified() {
        return this.onlyUnclassified;
    }

    public void setPercentage(double percentage) {
        if (percentage >= 0.0 && percentage <= 100.0) {
            this.percentage = percentage;
        }
    }

    public double getPercentage() {
        return this.percentage;
    }

    public double getKeyRatio() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.keyRatio;
    }

    private String determineIndex() {
        String result = "";
        ColumnLister lister = new ColumnLister(this.conn);
        lister.setTable(this.getTable());
        lister.setOnlyPrimary(true);
        Vector list = lister.getList();
        if (list.size() > 0) {
            result = list.get(0).toString();
        } else {
            lister.clear();
            lister.setTable(this.getTable());
            lister.setOnlyIndexes(true);
            list = lister.getList();
            if (list.size() > 0) {
                result = list.get(0).toString();
            }
        }
        if (this.getVerbose()) {
            this.println("Index determined: " + result);
        }
        return result;
    }

    private Column determineType(String column) {
        Column result = null;
        if (column.equals("")) {
            return result;
        }
        try {
            ResultSet rs = this.getConnector().getConnection().getMetaData().getColumns("", "", this.getTable(), column);
            result = rs.first() ? new Column(this.getClassField(), rs.getInt("DATA_TYPE")) : null;
            rs.close();
        }
        catch (Exception e) {
            this.println(e);
            result = null;
        }
        if (result == null) {
            this.println("Couldn't determine type of column '" + column + "'!");
        }
        if (result != null && this.getVerbose()) {
            this.println("Class '" + result.getName() + "' has type " + result.getType());
        }
        return result;
    }

    private void readKeys(String classValue) {
        if (this.getOnlyClassified() && Fingerprint.isNull(classValue)) {
            return;
        }
        if (this.getOnlyUnclassified() && !Fingerprint.isNull(classValue)) {
            return;
        }
        if (this.getVerbose()) {
            this.println("Determining keys for '" + this.getClassField() + "' and value '" + classValue + "' using index '" + this.getIndex() + "'...");
        }
        boolean where = false;
        String sql = "SELECT DISTINCT " + this.getIndex() + " FROM " + this.getTable();
        if (!classValue.equals("") && !Fingerprint.isNull(classValue)) {
            where = true;
            sql = String.valueOf(sql) + " WHERE " + this.getClassField() + " = ";
            sql = this.columnClass.isNominal() ? String.valueOf(sql) + "'" + classValue + "'" : String.valueOf(sql) + classValue;
        }
        if (this.getOnlyClassified()) {
            if (where) {
                sql = String.valueOf(sql) + " AND " + this.getClassField();
            }
            sql = String.valueOf(sql) + " IS NOT NULL";
        }
        if (this.getOnlyUnclassified()) {
            if (where) {
                sql = String.valueOf(sql) + " AND " + this.getClassField();
            }
            sql = String.valueOf(sql) + " IS NULL";
        }
        int count = this.exec.count(sql);
        int max = (int)StrictMath.round((double)count / 100.0 * this.percentage);
        ProperVector indexes = new ProperVector();
        RandomID randID = new RandomID(count, 1);
        while (randID.hasMoreElements() && indexes.size() < max) {
            indexes.add(randID.nextElement());
        }
        Collections.sort(indexes);
        if (this.getVerbose()) {
            this.println("Count: " + sql + "\n  => " + this.percentage + "% of " + count + " = " + indexes.size());
        }
        try {
            ResultSet rs = this.exec.select(sql);
            while (rs.next()) {
                if (indexes.isEmpty()) break;
                if (!indexes.get(0).equals(new Integer(rs.getRow()))) continue;
                indexes.remove(0);
                if (this.columnIndex.isNominal()) {
                    this.keys.add(rs.getString(1));
                    continue;
                }
                if (this.columnIndex.isInteger()) {
                    this.keys.add(new Integer(rs.getInt(1)));
                    continue;
                }
                if (this.columnIndex.isDecimal()) {
                    this.keys.add(new Double(rs.getDouble(1)));
                    continue;
                }
                this.keys.add(rs.getObject(1));
            }
            rs.close();
        }
        catch (Exception e) {
            this.println(e);
        }
    }

    private void initializeTypes() {
        if (this.getIndex().equals("")) {
            this.index = this.determineIndex();
            if (this.getIndex().equals("")) {
                this.println("Cannot determine index!");
                return;
            }
        }
        this.columnClass = this.determineType(this.getClassField());
        this.columnIndex = this.determineType(this.getIndex());
    }

    private void determineKeyRatio() {
        double distinct;
        double all;
        this.keyRatio = 1.0;
        if (this.getClassField().equals("")) {
            return;
        }
        if (this.getOnlyClassified()) {
            all = this.exec.getRecordCount(this.getTable(), this.getIndex(), true);
            distinct = this.exec.getDistinctCount(this.getTable(), this.getIndex());
        } else if (this.getOnlyUnclassified()) {
            all = this.exec.getRecordCount(this.getTable(), this.getIndex(), false);
            distinct = this.exec.getDistinctCount(this.getTable(), this.getIndex());
        } else {
            all = this.exec.getRecordCount(this.getTable());
            distinct = this.exec.getDistinctCount(this.getTable(), this.getIndex());
        }
        this.keyRatio = all / distinct;
        if (this.getVerbose()) {
            this.println("KeyRatio: " + this.keyRatio);
        }
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initializeTypes();
        this.determineKeyRatio();
        Vector values = !this.getClassField().equals("") ? this.exec.getDistinctValues(this.getTable(), this.getClassField()) : null;
        if (values == null) {
            this.readKeys("");
        } else {
            int i = 0;
            while (i < values.size()) {
                this.readKeys(values.get(i).toString());
                ++i;
            }
            if (this.getVerbose()) {
                this.println("Keys overall: " + this.keys.size());
            }
        }
        this.initialized = true;
    }

    public Iterator iterator() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.keys.iterator();
    }

    public int size() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.keys.size();
    }

    @Override
    public String toString() {
        String result = "Table     : '" + this.getTable() + "'\n" + "ClassField: '" + this.getClassField() + "'\n" + "Percentage: " + this.getPercentage() + "\n" + "# of Keys : " + this.keys.size();
        return result;
    }
}

