/*
 * Decompiled with CFR 0.152.
 */
package proper.gui;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import proper.app.Jobs;
import proper.gui.core.dialog.ErrorBox;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.ChildFrame;
import proper.gui.core.io.ImageLoader;
import proper.io.Shell;
import proper.util.ProperVector;
import proper.util.Strings;

public class Proper
extends ApplicationFrame {
    public static final String XML_GUI = "xml/gui.xml";
    private static final String ACTION_SHELL = "shell";
    private static final String ACTION_FRAME = "frame_";
    private static final String ACTION_MINIMIZE = "minimize";
    private static final String ACTION_RESTORE = "restore";
    private JMenuBar menuBar;
    private JMenu menuHelp;
    private JMenu menuWindow;
    private JMenu menuMilk;
    private JMenu menuWeka;
    private JMenuItem menuitemAbout;
    private JMenuItem menuitemSetup;
    private JMenuItem menuitemBuilder;
    private JMenuItem menuitemRun;
    private Hashtable menuItems;

    public Proper() {
        super("WEKA Proper - 16 Juin 2011");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.menuItems = new Hashtable();
        this.menuWindow = null;
        this.menuMilk = null;
        this.menuWeka = null;
        this.menuitemRun = null;
    }

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition(ACTION_SHELL, "a command that can be executed from the Program-Menu", true, "<command>", true);
    }

    @Override
    protected void createFrame() {
        super.createFrame();
        this.width = this.getGraphicsConfiguration().getBounds().width;
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.createMenu();
        this.pack();
        this.height = this.getHeight();
        this.setSize(this.width, this.getHeight());
        this.setLocation(0, 0);
        this.setResizable(false);
    }

    private void createWindowMenu() {
        if (this.menuWindow == null) {
            this.menuWindow = new JMenu("Windows");
            this.menuBar.remove(this.menuHelp);
            this.menuBar.add(this.menuWindow);
            this.menuBar.add(this.menuHelp);
        }
        this.menuWindow.removeAll();
        JMenuItem menuItem = new JMenuItem("Minimize");
        menuItem.setActionCommand(ACTION_MINIMIZE);
        menuItem.addActionListener(this);
        this.menuWindow.add(menuItem);
        menuItem = new JMenuItem("Restore");
        menuItem.setActionCommand(ACTION_RESTORE);
        menuItem.addActionListener(this);
        this.menuWindow.add(menuItem);
        this.menuWindow.addSeparator();
        Iterator iter = this.getWindowList();
        this.menuWindow.setVisible(iter.hasNext());
        while (iter.hasNext()) {
            ChildFrame frame = (ChildFrame)iter.next();
            menuItem = new JMenuItem(frame.getTitle());
            menuItem.addActionListener(this);
            menuItem.setActionCommand(ACTION_FRAME + Integer.toString(frame.hashCode()));
            this.menuWindow.add(menuItem);
        }
    }

    @Override
    public void windowListChanged() {
        this.createWindowMenu();
    }

    private void createCalls(String[] calls) {
        this.menuItems.clear();
        int i = 0;
        while (i < calls.length) {
            String params;
            String call;
            if (calls[i].indexOf(" ") == -1) {
                call = calls[i];
                params = "";
            } else {
                call = calls[i].substring(0, calls[i].indexOf(" "));
                params = calls[i].substring(calls[i].indexOf(" ") + 1, calls[i].length());
            }
            if (!call.endsWith("." + Proper.class.getName().replaceAll(".*\\.", ""))) {
                this.menuItems.put(call, params);
            }
            ++i;
        }
    }

    private String createMenuText(String menu) {
        String result = "";
        if (menu.length() > 0) {
            result = menu.substring(0, 1).toUpperCase();
            if (menu.length() > 1) {
                result = String.valueOf(result) + menu.substring(1, menu.length());
            }
        }
        return result;
    }

    private void createSubMenu(String name, JMenu menu, Vector items, Vector calls) {
        if (this.getVerbose()) {
            this.println("    -> " + items);
        }
        JMenu submenu = new JMenu(this.createMenuText(name));
        if (menu == null) {
            this.menuBar.add(submenu);
        } else {
            menu.add(submenu);
        }
        if (name.equals("help")) {
            this.menuHelp = submenu;
        }
        if (name.equals("milk")) {
            this.menuMilk = submenu;
        }
        if (name.equals("weka")) {
            this.menuWeka = submenu;
        }
        this.createMenuItems(submenu, items, calls);
        items.clear();
        calls.clear();
    }

    private void createMenuItems(JMenu menu, Vector items, Vector calls) {
        ProperVector newItems = new ProperVector();
        ProperVector newCalls = new ProperVector();
        String lastMenu = "";
        if (this.getVerbose()) {
            this.println("\n" + items);
        }
        int i = 0;
        while (i < items.size()) {
            String item = (String)items.get(i);
            if (this.getVerbose()) {
                System.out.println(" - item = " + item);
            }
            if (item.indexOf(".") > -1) {
                String currMenu = item.substring(0, item.indexOf("."));
                String subItem = item.substring(item.indexOf(".") + 1, item.length());
                if (this.getVerbose()) {
                    this.println("    - currMenu = " + currMenu);
                    this.println("    - lastMenu = " + lastMenu);
                    this.println("    - subItem  = " + subItem);
                }
                if (!lastMenu.equals("") && !lastMenu.equals(currMenu)) {
                    this.createSubMenu(lastMenu, menu, newItems, newCalls);
                }
                newItems.add(subItem);
                newCalls.add(calls.get(i));
                lastMenu = currMenu;
                if (i == items.size() - 1 && newItems.size() > 0) {
                    this.createSubMenu(currMenu, menu, newItems, newCalls);
                }
            } else {
                JMenuItem menuItem = new JMenuItem(this.createMenuText(item));
                menuItem.addActionListener(this);
                menuItem.setActionCommand(calls.get(i).toString());
                if (menu == null) {
                    this.menuBar.add(menuItem);
                } else {
                    menu.add(menuItem);
                }
                if (item.equals("About")) {
                    this.menuitemAbout = menuItem;
                }
                if (item.equals("Setup")) {
                    this.menuitemSetup = menuItem;
                }
                if (item.equals("Builder")) {
                    this.menuitemBuilder = menuItem;
                }
                if (item.equals("Run")) {
                    this.menuitemRun = menuItem;
                }
            }
            ++i;
        }
        if (this.getVerbose()) {
            this.println();
        }
    }

    private void reorderMenu() {
        JPopupMenu menu;
        if (this.menuMilk != null) {
            this.menuBar.remove(this.menuMilk);
            this.menuBar.add(this.menuMilk);
        }
        if (this.menuWeka != null) {
            this.menuBar.remove(this.menuWeka);
            this.menuBar.add(this.menuWeka);
        }
        if (this.menuHelp != null) {
            this.menuBar.remove(this.menuHelp);
            this.menuBar.add(this.menuHelp);
        }
        if (this.menuitemAbout != null) {
            menu = (JPopupMenu)this.menuitemAbout.getParent();
            menu.remove(this.menuitemAbout);
            menu.addSeparator();
            menu.add(this.menuitemAbout);
        }
        if (this.menuitemSetup != null) {
            menu = (JPopupMenu)this.menuitemSetup.getParent();
            menu.remove(this.menuitemSetup);
            menu.insert(this.menuitemSetup, 0);
        }
        if (this.menuitemBuilder != null) {
            menu = (JPopupMenu)this.menuitemBuilder.getParent();
            menu.remove(this.menuitemBuilder);
            menu.addSeparator();
            menu.add(this.menuitemBuilder);
        }
        if (this.menuitemRun != null) {
            menu = (JPopupMenu)this.menuitemRun.getParent();
            menu.remove(this.menuitemRun);
            menu.add(this.menuitemRun);
        }
    }

    private void createMenu() {
        JMenuItem menuItem;
        this.menuBar.removeAll();
        this.menuHelp = null;
        Jobs jobs = new Jobs();
        this.createCalls(jobs.getJobs(XML_GUI));
        ProperVector items = new ProperVector();
        ProperVector calls = new ProperVector();
        Enumeration enm = this.menuItems.keys();
        while (enm.hasMoreElements()) {
            calls.add(enm.nextElement());
        }
        Collections.sort(calls);
        int i = 0;
        while (i < calls.size()) {
            items.add(calls.get(i).toString().replaceAll("proper\\.gui\\.", ""));
            ++i;
        }
        JMenu menu = new JMenu("Program");
        this.menuBar.add(menu);
        if (this.cl.exists(ACTION_SHELL)) {
            menuItem = new JMenuItem("Shell", ImageLoader.getImageIcon("shell.gif"));
            menuItem.addActionListener(this);
            menuItem.setActionCommand(ACTION_SHELL);
            menu.add(menuItem);
        }
        menu.addSeparator();
        menuItem = new JMenuItem("Exit", ImageLoader.getImageIcon("forward.gif"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        menuItem.addActionListener(this);
        menuItem.setActionCommand("exit");
        menu.add(menuItem);
        this.createMenuItems(null, items, calls);
        this.reorderMenu();
        this.createWindowMenu();
    }

    private void launchMenu(String name) {
        ChildFrame win = ChildFrame.createInstance(name, this);
        if (win == null) {
            ErrorBox box = new ErrorBox(this, "Error", "Cannot instantiate '" + name + "'!");
            box.setSize(500, 100);
            box.show();
        } else {
            String[] args = this.menuItems.containsKey(name) ? Strings.breakUp((String)this.menuItems.get(name), " ", "\"") : new String[]{};
            try {
                win.run(args);
            }
            catch (Exception e) {
                this.println(e);
            }
        }
    }

    private void launchWindow(String action) {
        String hash = action.substring(ACTION_FRAME.length(), action.length());
        ChildFrame frame = null;
        Iterator iter = this.getWindowList();
        while (iter.hasNext()) {
            frame = (ChildFrame)iter.next();
            String hashFrame = Integer.toString(frame.hashCode());
            if (!hashFrame.equals(hash)) continue;
            this.showWindow(frame);
            break;
        }
    }

    private void launchShell() {
        Shell shell = new Shell(this.cl.getValue(ACTION_SHELL), false);
        if (shell.lastException() != null) {
            this.println(shell.lastException());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("exit")) {
            this.windowClosing(null);
        } else if (action.equals(ACTION_SHELL)) {
            this.launchShell();
        } else if (action.startsWith("proper.gui.")) {
            this.launchMenu(action);
        } else if (action.startsWith(ACTION_FRAME)) {
            this.launchWindow(action);
        } else if (action.startsWith(ACTION_MINIMIZE)) {
            this.minimizeWindows();
        } else if (action.startsWith(ACTION_RESTORE)) {
            this.restoreWindows();
        }
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.restoreWindows();
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.minimizeWindows();
    }

    @Override
    public void printDescription() {
        System.out.println("The main class containing the menu for starting all other tools.");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        Proper frame = new Proper();
        frame.run(args);
    }
}

