/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import proper.database.Connector;
import proper.gui.core.dialog.ProperDialog;
import proper.gui.core.event.ConnectorChangeListener;
import proper.gui.core.event.SizeChangeEvent;
import proper.gui.core.event.SizeChangeListener;
import proper.gui.core.frame.DummyFrame;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.panel.DatabasePanel;
import proper.gui.core.panel.OkCancelPanel;

public class DatabaseDialog
extends ProperDialog
implements SizeChangeListener {
    private DatabasePanel panelDB;
    private OkCancelPanel panelOkCancel;

    public DatabaseDialog() {
        this(new DummyFrame(), "Database");
    }

    public DatabaseDialog(ProperFrame parent) {
        this(parent, "Database");
    }

    public DatabaseDialog(String title) {
        this(new DummyFrame(), title);
    }

    public DatabaseDialog(ProperFrame parent, String title) {
        super(parent, title);
        this.initialize();
        this.createDialog();
    }

    @Override
    protected void createDialog() {
        super.createDialog();
        this.getContentPane().setLayout(new BorderLayout());
        this.panelDB = new DatabasePanel();
        this.panelDB.addActionListener(this);
        this.panelDB.addKeyListener(this);
        this.panelDB.addSizeChangeListener(this);
        this.getContentPane().add((Component)this.panelDB, "Center");
        this.panelOkCancel = new OkCancelPanel(true);
        this.panelOkCancel.addActionListener(this);
        this.panelOkCancel.addKeyListener(this);
        JPanel panel = new JPanel(new FlowLayout(4));
        panel.add(this.panelOkCancel);
        this.getContentPane().add((Component)panel, "South");
        this.getRootPane().setDefaultButton(this.panelOkCancel.buttonOK);
    }

    public void setConnector(Connector conn) {
        this.panelDB.setConnector(conn);
    }

    public Connector getConnector() {
        return this.panelDB.getConnector();
    }

    public void setDriver(String driver) {
        this.panelDB.setDriver(driver);
    }

    public String getDriver() {
        return this.panelDB.getDriver();
    }

    public void setUrl(String url) {
        this.panelDB.setUrl(url);
    }

    public String getUrl() {
        return this.panelDB.getUrl();
    }

    public void setUser(String user) {
        this.panelDB.setUser(user);
    }

    public String getUser() {
        return this.panelDB.getUser();
    }

    public void setPassword(String password) {
        this.panelDB.setPassword(password);
    }

    public String getPassword() {
        return this.panelDB.getPassword();
    }

    public void setExcludes(String excludes) {
        this.panelDB.setExcludes(excludes);
    }

    public String getExcludes() {
        return this.panelDB.getExcludes();
    }

    public void setShowDriver(boolean show) {
        this.panelDB.setShowDriver(show);
    }

    public boolean getShowDriver() {
        return this.panelDB.getShowDriver();
    }

    public void setShowConnect(boolean show) {
        this.panelDB.setShowConnect(show);
    }

    public boolean getShowConnect() {
        return this.panelDB.getShowConnect();
    }

    public void setShowTables(boolean show) {
        this.panelDB.setShowTables(show);
    }

    public boolean getShowTables() {
        return this.panelDB.getShowTables();
    }

    public void setShowColumns(boolean show) {
        this.panelDB.setShowColumns(show);
    }

    public boolean getShowColumns() {
        return this.panelDB.getShowColumns();
    }

    public String getDatabase() {
        return this.panelDB.getDatabase();
    }

    public void setPreferredDatabase(String preferredDatabase) {
        this.panelDB.setPreferredDatabase(preferredDatabase);
    }

    public String getPreferredDatabase() {
        return this.panelDB.getPreferredDatabase();
    }

    public String getTable() {
        return this.panelDB.getTable();
    }

    public void setPreferredTable(String preferredTable) {
        this.panelDB.setPreferredTable(preferredTable);
    }

    public String getPreferredTable() {
        return this.panelDB.getPreferredTable();
    }

    public String getColumn() {
        return this.panelDB.getColumn();
    }

    public void setPreferredColumn(String preferredColumn) {
        this.panelDB.setPreferredColumn(preferredColumn);
    }

    public String getPreferredColumn() {
        return this.panelDB.getPreferredColumn();
    }

    private void setSize() {
        if (this.panelDB.getPreferredSize().getWidth() > 0.0 && this.panelDB.getPreferredSize().getHeight() > 0.0) {
            this.setSize((int)(this.panelDB.getPreferredSize().getWidth() + 20.0), (int)(this.panelDB.getPreferredSize().getHeight() + this.panelOkCancel.getPreferredSize().getHeight() + 30.0));
        } else {
            this.height = 140;
            if (this.getShowDriver()) {
                this.height += 30;
            }
            if (this.getShowConnect()) {
                this.height += 30;
            }
            if (this.getShowTables()) {
                this.height += 30;
            }
            if (this.getShowColumns()) {
                this.height += 30;
            }
            this.setSize(720, this.height);
        }
    }

    @Override
    public void show() {
        try {
            if (this.getConnector() != null && this.getConnector().isConnected()) {
                this.setShowConnect(false);
                this.setConnector(this.getConnector());
            }
        }
        catch (Exception e) {
            this.getParentFrame().println(e);
        }
        this.setSize();
        this.setCenteredLocation();
        super.show();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("ok")) {
            this.approved = true;
            this.close();
        } else if (action.equals("cancel")) {
            this.close();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            e.consume();
            this.close();
        }
    }

    @Override
    public void sizeChanged(SizeChangeEvent e) {
        this.setSize();
    }

    public void removeConnectorChangeListener(ConnectorChangeListener listener) {
        this.panelDB.removeConnectorChangeListener(listener);
    }

    public void addConnectorChangeListener(ConnectorChangeListener listener) {
        this.panelDB.addConnectorChangeListener(listener);
    }
}

