/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.frame;

import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Iterator;
import proper.gui.core.frame.ChildFrame;
import proper.gui.core.frame.CommandLineFrame;

public class ApplicationFrame
extends CommandLineFrame {
    protected HashSet windows;

    public ApplicationFrame(String title) {
        super(title);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.windows = new HashSet();
    }

    public static ApplicationFrame createInstance(String classname) {
        ApplicationFrame result;
        try {
            Class<?> cls = Class.forName(classname);
            result = (ApplicationFrame)cls.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    @Override
    public void windowClosed(WindowEvent e) {
        System.exit(0);
    }

    public boolean closeWindows() {
        Iterator windows = this.getWindowList();
        while (windows.hasNext()) {
            ChildFrame child = (ChildFrame)windows.next();
            child.windowClosing(null);
        }
        boolean result = this.getWindowList() == null;
        return result;
    }

    public void addWindow(ChildFrame frame) {
        this.windows.add(frame);
        this.windowListChanged();
    }

    public void removeWindow(ChildFrame frame) {
        this.windows.remove(frame);
        this.windowListChanged();
    }

    public boolean showWindow(ChildFrame frame) {
        boolean result;
        if (frame != null) {
            frame.toFront();
            frame.setExtendedState(0);
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public Iterator getWindowList() {
        return this.windows.iterator();
    }

    public void minimizeWindows() {
        Iterator iter = this.getWindowList();
        while (iter.hasNext()) {
            ChildFrame frame = (ChildFrame)iter.next();
            frame.setExtendedState(1);
        }
    }

    public void restoreWindows() {
        Iterator iter = this.getWindowList();
        while (iter.hasNext()) {
            ChildFrame frame = (ChildFrame)iter.next();
            frame.setExtendedState(0);
        }
    }

    public void windowListChanged() {
    }

    public static void main(String[] args) throws Exception {
        ApplicationFrame frame = new ApplicationFrame("Frame-Test");
        frame.run(args);
    }
}

