/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.frame;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import proper.core.ProperInterface;
import proper.gui.core.dialog.MessageBox;
import proper.gui.core.io.ImageLoader;
import proper.io.Tee;
import proper.util.ProperVector;
import proper.util.Strings;

public abstract class ProperFrame
extends JFrame
implements WindowListener,
ActionListener,
KeyListener,
ProperInterface,
DocumentListener,
MouseListener {
    private static final String ICON = "proper_small.gif";
    protected static final int WIDTH = 800;
    protected static final int HEIGHT = 600;
    protected static final int DEFAULT_WIDTH = -1;
    protected static final int DEFAULT_HEIGHT = -1;
    protected static final int DEFAULT_LEFT = -1;
    protected static final int DEFAULT_TOP = -1;
    protected static final String ACTION_EXIT = "exit";
    protected int width;
    protected int height;
    protected int top;
    protected int left;
    protected String frameTitle;
    private int verboseLevel;
    private Tee tee;
    private Vector listeners;
    protected String verboseStr;
    private Runtime runtime;
    protected JLabel labelStatus;

    public ProperFrame(String title) {
        super(title);
        this.initialize();
    }

    protected String getIconFilename() {
        return ICON;
    }

    protected void setProperIcon() {
        this.setIconImage(ImageLoader.getImage(this.getIconFilename()));
    }

    protected void initialize() {
        this.verboseStr = "";
        this.verboseLevel = 0;
        this.listeners = new ProperVector();
        this.tee = new Tee();
        this.runtime = Runtime.getRuntime();
        this.frameTitle = this.getTitle();
    }

    protected void createFrame() {
        this.setProperIcon();
        this.setSize(800, 600);
        this.setCenteredLocation();
        this.setDefaultCloseOperation(2);
        this.removeWindowListener(this);
        this.addWindowListener(this);
        this.labelStatus = new JLabel();
    }

    protected void resizeFrame() {
        if (this.width != -1) {
            this.setSize(this.width, this.getSize().height);
        }
        if (this.height != -1) {
            this.setSize(this.getSize().width, this.height);
        }
        this.setCenteredLocation();
        if (this.top != -1) {
            this.setLocation(this.getLocation().x, this.top);
        }
        if (this.left != -1) {
            this.setLocation(this.left, this.getLocation().y);
        }
    }

    protected void setEnabledState(boolean enabled) {
    }

    protected int getCenteredLeft() {
        int width = this.getBounds().width;
        int x = (this.getGraphicsConfiguration().getBounds().width - width) / 2;
        if (x < 0) {
            x = 0;
        }
        return x;
    }

    protected int getCenteredTop() {
        int height = this.getBounds().height;
        int y = (this.getGraphicsConfiguration().getBounds().height - height) / 2;
        if (y < 0) {
            y = 0;
        }
        return y;
    }

    public void setCenteredLocation() {
        this.setLocation(this.getCenteredLeft(), this.getCenteredTop());
    }

    public void refresh() {
        this.validate();
        this.repaint();
    }

    public void showStatus(String status) {
        this.labelStatus.setText(status);
        this.labelStatus.repaint();
    }

    public int showMessageBox(String title, String msg, String[] buttons, String icon) {
        return this.showMessageBox(title, msg, buttons, icon, 300, 100);
    }

    public int showMessageBox(String title, String msg, String[] buttons, String icon, int width, int height) {
        MessageBox box = new MessageBox(this, title, msg, buttons, icon, width, height);
        box.show();
        return box.getPressedButton();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void addListener(ProperInterface o) {
        if (!this.listeners.contains(o)) {
            this.listeners.add(o);
            this.notifyListener(o);
        }
    }

    @Override
    public void removeListener(ProperInterface o) {
        if (this.listeners.contains(o)) {
            this.listeners.remove(this.listeners.indexOf(o));
        }
    }

    @Override
    public Vector getListeners() {
        return this.listeners;
    }

    @Override
    public void notifyListener(ProperInterface o) {
        o.setVerboseString(this.getVerboseString());
        int i = 0;
        while (i < this.tee.size()) {
            o.addOutput(this.tee.get(i));
            ++i;
        }
    }

    @Override
    public void notifyListeners() {
        int i = 0;
        while (i < this.getListeners().size()) {
            this.notifyListener((ProperInterface)this.getListeners().get(i));
            ++i;
        }
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verboseLevel = verbose ? 1 : 0;
    }

    @Override
    public boolean getVerbose() {
        return this.getVerboseLevel() > 0;
    }

    @Override
    public void setVerboseLevel(int verboseLevel) {
        if (verboseLevel >= 0) {
            this.verboseLevel = verboseLevel;
        }
    }

    @Override
    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    @Override
    public void setOutput(PrintStream out) {
        this.tee.clear();
        this.addOutput(out);
    }

    @Override
    public void addOutput(PrintStream out) {
        this.tee.add(out);
        this.notifyListeners();
    }

    @Override
    public String getVerboseStringForClass(String classname) {
        String result = "";
        if (this.verboseStr != null) {
            String[] data = Strings.fromCommalist(this.verboseStr);
            int i = 0;
            while (i < data.length) {
                String tmp = data[i];
                if (tmp.indexOf(":") > -1) {
                    tmp = tmp.substring(0, data[i].indexOf(":"));
                }
                if (classname.endsWith("." + tmp) || tmp.equals(classname) || tmp.equals("all")) {
                    result = data[i];
                    break;
                }
                if (tmp.endsWith(".*") && classname.startsWith(tmp.substring(0, tmp.length() - 1))) {
                    result = data[i];
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public int getVerboseLevelForClass(String classname) {
        int result = 0;
        String verbose = this.getVerboseStringForClass(classname);
        if (!verbose.equals("")) {
            if (verbose.indexOf(":") > -1) {
                try {
                    result = Integer.parseInt(verbose.substring(verbose.indexOf(":") + 1, verbose.length()));
                }
                catch (Exception e) {
                    this.println(e);
                    result = 0;
                }
            } else {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public boolean classInVerbose(String classname) {
        return !this.getVerboseStringForClass(classname).equals("");
    }

    @Override
    public void setVerboseString(String verboseStr) {
        this.verboseStr = verboseStr;
        this.setVerboseLevel(this.getVerboseLevelForClass(this.getClass().getName()));
        this.notifyListeners();
    }

    @Override
    public String getVerboseString() {
        return this.verboseStr;
    }

    @Override
    public Runtime getRuntime() {
        return this.runtime;
    }

    @Override
    public void printMemory() {
        double free = this.getRuntime().freeMemory();
        double freeM = (double)StrictMath.round(free / 1048576.0 * 10.0) / 10.0;
        double total = this.getRuntime().totalMemory();
        double totalM = (double)StrictMath.round(total / 1048576.0 * 10.0) / 10.0;
        this.println("Memory: " + freeM + "M (" + (long)free + ") / " + totalM + "M (" + (long)total + ")");
    }

    @Override
    public void print(int x) {
        this.tee.print(x);
    }

    @Override
    public void print(boolean x) {
        this.tee.print(x);
    }

    @Override
    public void print(String x) {
        this.tee.print(x);
    }

    @Override
    public void print(Object x) {
        this.tee.print(x);
    }

    @Override
    public void println() {
        this.tee.println();
    }

    @Override
    public void println(int x) {
        this.tee.println(x);
    }

    @Override
    public void println(boolean x) {
        this.tee.println(x);
    }

    @Override
    public void println(String x) {
        this.tee.println(x);
    }

    @Override
    public void println(Object x) {
        this.tee.println(x);
    }

    @Override
    public void debugprint(int x) {
        this.print(x);
    }

    @Override
    public void debugprint(boolean x) {
        this.print(x);
    }

    @Override
    public void debugprint(String x) {
        this.print(x);
    }

    @Override
    public void debugprint(Object x) {
        this.print(x);
    }

    @Override
    public void debugprintln() {
        this.println();
    }

    @Override
    public void debugprintln(int x) {
        this.println(x);
    }

    @Override
    public void debugprintln(boolean x) {
        this.println(x);
    }

    @Override
    public void debugprintln(String x) {
        this.println(x);
    }

    @Override
    public void debugprintln(Object x) {
        this.println(x);
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }
}

