/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ResultSetTableModel
implements TableModel {
    private HashSet listeners = new HashSet();
    private ResultSet rs;
    private ResultSetMetaData meta;
    private Object[][] data = null;

    public ResultSetTableModel(ResultSet rs) {
        this.rs = rs;
        try {
            this.meta = rs != null ? rs.getMetaData() : null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadData();
    }

    private void loadData() {
        try {
            this.rs.last();
            this.data = new Object[this.rs.getRow()][this.meta.getColumnCount()];
            if (this.data.length == 0) {
                return;
            }
            this.rs.first();
            int n = 0;
            do {
                int i = 0;
                while (i < this.meta.getColumnCount()) {
                    this.data[n][i] = this.rs.getObject(i + 1);
                    ++i;
                }
                ++n;
            } while (this.rs.next());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    public Class getColumnClass(int columnIndex) {
        Class result = null;
        if (this.meta != null && columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            if (columnIndex == 0) {
                result = Integer.class;
            } else {
                try {
                    result = Class.forName(this.meta.getColumnClassName(columnIndex));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = null;
                }
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 0;
        if (this.meta != null) {
            try {
                result = this.meta.getColumnCount() + 1;
            }
            catch (Exception e) {
                e.printStackTrace();
                result = 0;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result = "";
        if (this.meta != null && columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            if (columnIndex == 0) {
                result = "Row";
            } else {
                try {
                    result = this.meta.getColumnName(columnIndex);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = "";
                }
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex >= 0 & columnIndex < this.getColumnCount()) {
            result = columnIndex == 0 ? new Integer(rowIndex + 1) : this.data[rowIndex][columnIndex - 1];
        }
        if (result == null) {
            result = "[NULL]";
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    private void notifyListener(int rowIndex, int columnIndex) {
        if (this.listeners.size() > 0) {
            for (TableModelListener l : this.listeners) {
                l.tableChanged(new TableModelEvent(this, rowIndex, columnIndex));
            }
        }
    }
}

