/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.text;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.io.ImageLoader;

public abstract class ProperTextField
extends JPanel
implements ActionListener {
    private ProperFrame parent;
    private JTextField textField;
    private JButton buttonField;
    private int columns;
    private String text;
    private int type;
    private boolean useIcon;

    public ProperTextField(ProperFrame parent) {
        this(parent, 20);
    }

    public ProperTextField(ProperFrame parent, int columns) {
        this(parent, "", columns);
    }

    public ProperTextField(ProperFrame parent, String text, int columns) {
        this(parent, text, columns, false);
    }

    public ProperTextField(ProperFrame parent, String text, int columns, boolean useIcon) {
        this.parent = parent;
        this.text = text;
        this.columns = columns;
        this.useIcon = useIcon;
        this.initialize();
        this.createPanel();
    }

    protected void initialize() {
    }

    protected void createPanel() {
        this.setLayout(new FlowLayout(3, 0, 0));
        this.textField = new JTextField(this.text, this.columns);
        this.add(this.textField);
        this.buttonField = this.getUseIcon() ? new JButton(ImageLoader.getImageIcon("open.gif")) : new JButton("...");
        this.buttonField.addActionListener(this);
        this.add(this.buttonField);
    }

    public ProperFrame getParentFrame() {
        return this.parent;
    }

    public boolean getUseIcon() {
        return this.useIcon;
    }

    public void setColumns(int columns) {
        this.textField.setColumns(columns);
    }

    public int getColumns() {
        return this.textField.getColumns();
    }

    @Override
    public void setToolTipText(String text) {
        this.textField.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        return this.textField.getToolTipText();
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public String getText() {
        return this.textField.getText();
    }

    protected abstract void openDialog();

    public Document getDocument() {
        return this.textField.getDocument();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonField) {
            this.openDialog();
        }
    }
}

