/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import proper.database.Connector;
import proper.gui.core.panel.ProperPanel;
import proper.gui.core.text.DatabaseTextField;
import proper.gui.core.text.ProperTextField;
import proper.gui.core.text.RelationsTextField;
import proper.gui.experiment.Builder;
import proper.gui.experiment.BuilderParameter;
import proper.io.CommandLine;
import proper.util.ProperVector;
import proper.xml.Attribute;
import proper.xml.Element;
import proper.xml.XMLAccessInterface;

public class BuilderPanel
extends ProperPanel
implements ItemListener,
XMLAccessInterface {
    private JLabel labelNote;
    private Builder parent;
    private boolean changed;
    private String name;
    private Vector parameters;
    private boolean needsDatabase;
    private String classname;

    public BuilderPanel(Builder parent, String name) {
        this.parent = parent;
        this.name = name;
        parent.addPanel(this);
        this.initialize();
        this.createPanel();
        this.clear();
    }

    @Override
    protected void initialize() {
        this.changed = false;
        this.parameters = new ProperVector();
        this.needsDatabase = false;
        this.classname = "";
    }

    @Override
    protected void createPanel() {
        super.createPanel();
        this.setLayout(new BorderLayout());
        this.labelNote = new JLabel();
        this.add((Component)this.labelNote, "South");
    }

    public Builder getParentFrame() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int i = 0;
        while (i < this.getComponentCount()) {
            this.getComponent(i).setEnabled(enabled);
            ++i;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        int i = 0;
        while (i < this.getComponentCount()) {
            this.getComponent(i).setVisible(visible);
            ++i;
        }
    }

    public void setNote(String note) {
        this.labelNote.setText(note);
    }

    public String getNote() {
        return this.labelNote.getText();
    }

    public void setConnector(Connector conn) {
        int i = 0;
        while (i < this.parameters.size()) {
            JComponent obj = ((BuilderParameter)this.parameters.get(i)).getComponent();
            if (obj instanceof DatabaseTextField) {
                ((DatabaseTextField)obj).setConnector(conn);
            } else if (obj instanceof RelationsTextField) {
                ((RelationsTextField)obj).setConnector(conn);
            }
            ++i;
        }
    }

    public Connector getConnector() {
        Connector result = null;
        int i = 0;
        while (i < this.parameters.size()) {
            JComponent obj = ((BuilderParameter)this.parameters.get(i)).getComponent();
            if (obj instanceof DatabaseTextField) {
                result = ((DatabaseTextField)obj).getConnector();
                break;
            }
            if (obj instanceof RelationsTextField) {
                result = ((RelationsTextField)obj).getConnector();
                break;
            }
            ++i;
        }
        return result;
    }

    public void setNeedsDatabase(boolean needsDatabase) {
        this.needsDatabase = needsDatabase;
    }

    public boolean needsDatabase() {
        return this.needsDatabase;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getClassname() {
        return this.classname;
    }

    protected void addListener(JComponent c) {
        if (c == null) {
            return;
        }
        if (c instanceof JTextField) {
            ((JTextField)c).getDocument().addDocumentListener(this);
        } else if (c instanceof ProperTextField) {
            ((ProperTextField)c).getDocument().addDocumentListener(this);
        } else if (c instanceof JComboBox) {
            ((JComboBox)c).addItemListener(this);
        } else if (c instanceof JCheckBox) {
            ((JCheckBox)c).addItemListener(this);
        }
    }

    protected void removeListener(JComponent c) {
        if (c == null) {
            return;
        }
        if (c instanceof JTextField) {
            ((JTextField)c).getDocument().removeDocumentListener(this);
        } else if (c instanceof ProperTextField) {
            ((ProperTextField)c).getDocument().removeDocumentListener(this);
        } else if (c instanceof JComboBox) {
            ((JComboBox)c).removeItemListener(this);
        } else if (c instanceof JCheckBox) {
            ((JCheckBox)c).removeItemListener(this);
        }
    }

    public void addParameter(BuilderParameter param) {
        this.parameters.add(param);
        this.addListener(param.getComponent());
    }

    public BuilderParameter getParameter(String parameter) {
        BuilderParameter result = null;
        int i = 0;
        while (i < this.parameters.size()) {
            BuilderParameter param = (BuilderParameter)this.parameters.get(i);
            if (param.getParameter().equals(parameter)) {
                result = param;
                break;
            }
            ++i;
        }
        return result;
    }

    public BuilderParameter getParameter(JComponent component) {
        BuilderParameter result = null;
        int i = 0;
        while (i < this.parameters.size()) {
            BuilderParameter param = (BuilderParameter)this.parameters.get(i);
            if (param.getComponent() == component) {
                result = param;
                break;
            }
            ++i;
        }
        return result;
    }

    public Vector getParameters() {
        return this.parameters;
    }

    public void clear() {
        int i = 0;
        while (i < this.parameters.size()) {
            BuilderParameter param = (BuilderParameter)this.parameters.get(i);
            this.removeListener(param.getComponent());
            this.removeListener(param.getUseComponent());
            if (param.getUseComponent() instanceof JCheckBox) {
                ((JCheckBox)param.getUseComponent()).setSelected(param.isUsed());
            }
            this.setComponentText(param.getComponent(), param.getValue());
            this.addListener(param.getComponent());
            this.removeListener(param.getUseComponent());
            this.addListener(param.getUseComponent());
            ++i;
        }
        this.setChanged(false);
    }

    public Vector check() {
        ProperVector result = new ProperVector();
        if (!this.getParentFrame().getSteps().isChecked(this.getName())) {
            return result;
        }
        int i = 0;
        while (i < this.parameters.size()) {
            boolean error = false;
            BuilderParameter param = (BuilderParameter)this.parameters.get(i);
            if (!param.isOptional() && this.getComponentText(param.getComponent()).equals("")) {
                error = true;
            }
            if (param.isOptional() && ((JCheckBox)param.getUseComponent()).isSelected() && this.getComponentText(param.getComponent()).equals("")) {
                error = true;
            }
            if (error) {
                String errorMsg = String.valueOf(this.getName()) + "/" + param.getLabel() + ": " + "incorrect data (e.g., empty)";
                result.add(errorMsg);
            }
            ++i;
        }
        return result;
    }

    protected Element createTarget(String name) {
        Element result = new Element("target");
        result.addAttribute(new Attribute("name", name));
        return result;
    }

    protected Element addArgument(Element node, String value) {
        Element arg = new Element("arg");
        arg.addAttribute(new Attribute("value", value));
        node.add(arg);
        return node;
    }

    protected Element createJavaCall(String classname) {
        Element result = new Element("java");
        result.addAttribute(new Attribute("classname", classname));
        result.addAttribute(new Attribute("fork", "yes"));
        result.addAttribute(new Attribute("maxmemory", "${memory}"));
        Element node = new Element(result, "classpath");
        node.addAttribute(new Attribute("refid", "project.class.path"));
        result = this.addVerbose(result);
        return result;
    }

    protected Element addDatabase(Element node) {
        node = this.addArgument(node, "-url");
        node = this.addArgument(node, "${url}");
        node = this.addArgument(node, "-user");
        node = this.addArgument(node, "${user}");
        node = this.addArgument(node, "-password");
        node = this.addArgument(node, "${password}");
        node = this.addArgument(node, "-driver");
        node = this.addArgument(node, "${driver}");
        node = this.addArgument(node, "-sql_limit");
        node = this.addArgument(node, "${sql_limit}");
        return node;
    }

    protected Element addLog(Element node) {
        node = this.addArgument(node, "-log");
        node = this.addArgument(node, "${log}");
        node = this.addArgument(node, "-append_log");
        node = this.addArgument(node, "${append_log}");
        return node;
    }

    protected Element addVerbose(Element node) {
        node = this.addArgument(node, "-verbose");
        node = this.addArgument(node, "${verbose}");
        return node;
    }

    protected String getComponentText(JComponent comp) {
        String result = "";
        if (comp instanceof JTextField) {
            result = ((JTextField)comp).getText();
        } else if (comp instanceof JCheckBox) {
            result = ((JCheckBox)comp).isSelected() ? "yes" : "no";
        } else if (comp instanceof JComboBox) {
            result = ((JComboBox)comp).getSelectedItem().toString();
        } else if (comp instanceof JSpinner) {
            result = ((JSpinner)comp).getValue().toString();
        } else if (comp instanceof ProperTextField) {
            result = ((ProperTextField)comp).getText();
        }
        if (result.startsWith("-")) {
            result = "=" + result.substring(1, result.length());
        }
        return result;
    }

    protected void setComponentText(JComponent comp, String text) {
        if (text.startsWith("=")) {
            text = "-" + text.substring(1, text.length());
        }
        if (comp instanceof JTextField) {
            ((JTextField)comp).setText(text);
        } else if (comp instanceof JCheckBox) {
            ((JCheckBox)comp).setSelected(text.equals("yes"));
        } else if (comp instanceof JComboBox) {
            ((JComboBox)comp).setSelectedItem(text);
        } else if (comp instanceof JSpinner) {
            ((JSpinner)comp).setValue(new Integer(text));
        } else if (comp instanceof ProperTextField) {
            ((ProperTextField)comp).setText(text);
        }
    }

    protected Element addValue(Element node, String name, JComponent comp) {
        String value = this.getComponentText(comp);
        node = this.addArgument(node, "-" + name);
        if (value.startsWith("-")) {
            value = "=" + value.substring(1, value.length());
        }
        if (!(comp instanceof JCheckBox)) {
            node = this.addArgument(node, value);
        }
        return node;
    }

    @Override
    public void fromXML(Element node) {
        BuilderParameter param;
        int i = 0;
        while (i < this.parameters.size()) {
            param = (BuilderParameter)this.parameters.get(i);
            if (param.getUseComponent() instanceof JCheckBox) {
                ((JCheckBox)param.getUseComponent()).setSelected(false);
            }
            ++i;
        }
        ProperVector args = new ProperVector();
        i = 0;
        while (i < node.getChildCount()) {
            Element subnode = (Element)node.getChildAt(i);
            if (subnode.getAttribute("value") != null) {
                args.add(subnode.getAttribute("value").getValue());
            }
            ++i;
        }
        CommandLine cl = new CommandLine(args);
        Vector params = cl.getParameters();
        i = 0;
        while (i < params.size()) {
            String name = (String)params.get(i);
            param = this.getParameter(name);
            if (param == null) {
                if (!(name.equals("verbose") || name.equals("sql_limit") || name.equals("driver") || name.equals("url") || name.equals("user") || name.equals("password"))) {
                    this.getParentFrame().println("Unknown parameter: " + name);
                }
            } else {
                String text = cl.hasValue(name) ? cl.getValue(name) : "";
                if (text.equals("") && param.getComponent() instanceof JCheckBox) {
                    text = "yes";
                }
                this.setComponentText(param.getComponent(), text);
                if (param.getUseComponent() instanceof JCheckBox) {
                    ((JCheckBox)param.getUseComponent()).setSelected(true);
                }
            }
            ++i;
        }
    }

    @Override
    public Element toXML() {
        Element node = new Element("target");
        node.addAttribute(new Attribute("name", this.getName().toLowerCase()));
        Element subnode = this.createJavaCall(this.getClassname());
        node.add(subnode);
        if (this.needsDatabase()) {
            subnode = this.addDatabase(subnode);
        }
        subnode = this.addVerbose(subnode);
        int i = 0;
        while (i < this.parameters.size()) {
            BuilderParameter param = (BuilderParameter)this.parameters.get(i);
            if (!param.isOptional() || param.isOptional() && ((JCheckBox)param.getUseComponent()).isSelected()) {
                this.addValue(subnode, param.getParameter(), param.getComponent());
            }
            ++i;
        }
        return node;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.changed = true;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changed = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changed = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.changed = true;
    }
}

