/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.experiment;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JScrollPane;
import proper.gui.core.table.JTableHelper;
import proper.gui.core.table.PropertyTable;
import proper.gui.experiment.Builder;
import proper.gui.experiment.BuilderPanel;
import proper.xml.Attribute;
import proper.xml.Element;

public class BuilderProperties
extends BuilderPanel {
    private PropertyTable tableProperties;
    private String[][] defaultValues;

    public BuilderProperties(Builder parent, String title) {
        super(parent, title);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.defaultValues = new String[][]{{"", ""}};
    }

    @Override
    protected void createPanel() {
        super.createPanel();
        this.tableProperties = new PropertyTable();
        JScrollPane pane = new JScrollPane(this.tableProperties);
        this.add((Component)pane, "Center");
        this.setNote("Note: a property that is defined here can be used in the fields with a shortcut, e.g. 'datasets' can be used as '${datasets}'");
    }

    @Override
    public void setChanged(boolean changed) {
        this.tableProperties.setChanged(changed);
    }

    @Override
    public boolean isChanged() {
        return this.tableProperties.isChanged();
    }

    public void setDefaultValues(String[][] defaultValues) {
        this.defaultValues = defaultValues;
    }

    public String getValue(String name) {
        String result = null;
        int i = 0;
        while (i < this.tableProperties.getRowCount()) {
            if (this.tableProperties.getValueAt(i, 0).toString().equals(name)) {
                result = this.tableProperties.getValueAt(i, 1).toString();
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        Object[][] props = new String[this.defaultValues.length][2];
        int i = 0;
        while (i < props.length) {
            props[i][0] = new String(this.defaultValues[i][0]);
            props[i][1] = new String(this.defaultValues[i][1]);
            ++i;
        }
        this.tableProperties.setProperties(props);
        JTableHelper.setOptimalColumnWidth(this.tableProperties);
    }

    @Override
    public void fromXML(Element node) {
        Object[][] props = new Object[node.getChildCount()][2];
        int i = 0;
        while (i < node.getChildCount()) {
            Element subnode = (Element)node.getChildAt(i);
            props[i][0] = subnode.getAttribute("name").getValue();
            props[i][1] = subnode.getAttribute("value").getValue();
            ++i;
        }
        this.tableProperties.setProperties(props);
        JTableHelper.setOptimalColumnWidth(this.tableProperties);
    }

    @Override
    public Element toXML() {
        Object[][] props = this.tableProperties.getProperties();
        Element result = new Element(this.getName());
        int i = 0;
        while (i < props.length) {
            Element node = new Element("property");
            node.addAttribute(new Attribute("name", props[i][0].toString()));
            node.addAttribute(new Attribute("value", props[i][1].toString()));
            result.add(node);
            ++i;
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

