/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JScrollPane;
import proper.gui.core.dialog.ProperDialog;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.panel.OkCancelPanel;
import proper.gui.core.table.JTableHelper;
import proper.gui.core.table.PropertyTable;
import proper.io.Ant;

public class ExperimentOptions
extends ProperDialog {
    private Ant ant;
    private JScrollPane paneOptions;
    private PropertyTable tableOptions;
    private OkCancelPanel panelButtons;

    public ExperimentOptions(ProperFrame parent, Ant ant) {
        super(parent, "Options");
        this.createDialog();
        this.ant = ant;
        this.tableOptions.setProperties(this.getOptions());
        JTableHelper.setOptimalColumnWidth(this.tableOptions);
    }

    private String[][] getOptions() {
        Vector props = this.ant.getProperties();
        String[][] result = new String[props.size()][2];
        int i = 0;
        while (i < props.size()) {
            result[i][0] = (String)props.get(i);
            result[i][1] = this.ant.getProperty(result[i][0]);
            ++i;
        }
        return result;
    }

    private void setOptions() {
        Object[][] props = this.tableOptions.getProperties();
        int i = 0;
        while (i < props.length) {
            if (!this.ant.getProperty(props[i][0].toString()).equals(props[i][1])) {
                this.getParentFrame().println(props[i][0] + " changed to " + props[i][1]);
                this.ant.setProperty(props[i][0].toString(), props[i][1].toString());
            }
            ++i;
        }
    }

    @Override
    protected void createDialog() {
        super.createDialog();
        this.setSize(800, 600);
        this.setCenteredLocation();
        this.getContentPane().setLayout(new BorderLayout());
        this.tableOptions = new PropertyTable();
        this.paneOptions = new JScrollPane(this.tableOptions);
        this.getContentPane().add((Component)this.paneOptions, "Center");
        this.panelButtons = new OkCancelPanel();
        this.panelButtons.addActionListener(this);
        this.getContentPane().add((Component)this.panelButtons, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("ok")) {
            this.setOptions();
            this.close();
        } else if (action.equals("cancel")) {
            this.close();
        }
    }
}

