/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.experiment;

import java.util.Vector;
import javax.swing.DefaultListModel;
import org.apache.tools.ant.Task;
import proper.app.Application;
import proper.gui.core.frame.FrameThread;
import proper.gui.experiment.Run;
import proper.io.Ant;
import proper.io.AntTarget;
import proper.io.CommandLine;
import proper.util.ProperVector;

class RunExecutor
extends FrameThread {
    private Run owner;

    public RunExecutor(Run owner) {
        super(owner);
        this.owner = owner;
    }

    @Override
    public void run() {
        int i;
        this.beforeRun();
        if (this.owner.getParameters().hasValue("autorun")) {
            this.owner.setVisible(false);
        }
        this.owner.errorList.clear();
        DefaultListModel model = (DefaultListModel)this.owner.listTargets.getModel();
        ProperVector targets = new ProperVector();
        if (this.owner.listTargets.getSelectedIndex() == -1) {
            i = 0;
            while (i < model.size()) {
                targets.add(model.getElementAt(i));
                ++i;
            }
        } else {
            i = 0;
            while (i < this.owner.listTargets.getSelectedIndices().length) {
                targets.add(model.getElementAt(this.owner.listTargets.getSelectedIndices()[i]));
                ++i;
            }
        }
        i = 0;
        while (i < targets.size()) {
            this.owner.showStatus(String.valueOf(i + 1) + "/" + targets.size());
            AntTarget target = (AntTarget)targets.get(i);
            Vector tasks = target.getJavaTasks();
            Ant ant = target.getAnt();
            if (tasks != null && tasks.size() != 0) {
                int n = 0;
                while (n < tasks.size()) {
                    try {
                        Task task = (Task)tasks.get(n);
                        Application app = Application.createInstance(ant.getClassname(task));
                        this.owner.addListener(app);
                        CommandLine cl = new CommandLine(ant.getArguments(task));
                        cl.setValue("verbose", this.owner.getVerboseString());
                        if (!app.run(cl.toArray())) {
                            this.owner.errorList.add(task);
                        }
                        this.owner.removeListener(app);
                    }
                    catch (Exception e) {
                        this.owner.println(e);
                    }
                    this.owner.println("\n---\n");
                    if (!this.isRunning()) break;
                    ++n;
                }
                if (!this.isRunning()) break;
            }
            ++i;
        }
        this.afterRun();
        if (this.owner.getParameters().hasValue("autorun")) {
            this.owner.close();
        }
        if (this.owner.errorList.size() > 0) {
            this.owner.displayErrors();
        }
    }
}

