/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.remote;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import proper.gui.core.dialog.EditDialog;
import proper.gui.core.dialog.FileChooser;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.ChildFrame;
import proper.gui.core.io.ImageLoader;
import proper.gui.core.list.List;
import proper.gui.remote.JobListener;
import proper.io.Shell;
import proper.io.TextFile;
import proper.net.Address;
import proper.net.Data;
import proper.remote.JobAdder;
import proper.remote.messages.DataMessage;
import proper.remote.messages.Message;
import proper.util.ProperVector;
import proper.util.Strings;
import proper.util.Timer;
import proper.util.TimerInterface;

public class JobMonitor
extends ChildFrame
implements TimerInterface,
ChangeListener {
    public static final int PORT = 31417;
    public static final int REFRESH = 60;
    private static final String ACTION_REFRESH = "refresh";
    private static final String ACTION_DELETE = "delete_job";
    private static final String ACTION_ADDJOBS = "add_jobs";
    private static final String ACTION_SAVEJOBS = "save_jobs";
    private static final String ACTION_CONNECT = "connect";
    private static final String ACTION_SHUTDOWNSERVER = "shutdown_server";
    private static final String ACTION_SHUTDOWNCLIENT = "shutdown_client";
    private static final String ACTION_KILLCLIENT = "kill_client";
    private static final String ACTION_REREGISTERCLIENT = "reregister_client";
    private static final String ACTION_SHELL = "shell";
    private static final String ACTION_VIEW = "view";
    private static final String TAB_TODO = "ToDo";
    private static final String TAB_DONE = "Done";
    private static final String TAB_FAILED = "Failed";
    private static final String TAB_CLIENTS = "Clients";
    private static final String TAB_PENDING = "Pending";
    private static final String TAB_ADDITIONAL = "Additional";
    private JTabbedPane tabbedPane;
    private JPanel panelJobsTodo;
    private JPanel panelJobsDone;
    private JPanel panelJobsFailed;
    private JPanel panelClients;
    private JPanel panelPending;
    private JPanel panelAdditional;
    private List listJobsTodo;
    private List listJobsDone;
    private List listJobsFailed;
    private List listClients;
    private List listPending;
    private List listAdditional;
    private JLabel labelServer;
    private JLabel labelPort;
    private JLabel labelRefresh;
    private JLabel labelEntries;
    private JTextField textServer;
    private JTextField textPort;
    private JTextField textRefresh;
    private JButton buttonRefresh;
    private JButton buttonDelete;
    private JButton buttonAddJobs;
    private JButton buttonSaveJobs;
    private JButton buttonExit;
    private JButton buttonConnect;
    private JButton buttonShutdownServer;
    private JButton buttonShutdownClient;
    private JButton buttonKillClient;
    private JButton buttonReregisterClient;
    private JButton buttonShell;
    private JScrollPane paneJobsTodo;
    private JScrollPane paneJobsDone;
    private JScrollPane paneJobsFailed;
    private JScrollPane paneClients;
    private JScrollPane panePending;
    private JScrollPane paneAdditional;
    private FileChooser fileChooser;
    private String server;
    private String port;
    private String localPort;
    private String refresh;
    private JobListener listener;
    private boolean serverIsAlive;
    private Data sender;
    private Timer timer;

    public JobMonitor(ApplicationFrame parent) {
        super(parent, "Job-Monitor");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.server = "localhost";
        this.port = Integer.toString(31415);
        this.localPort = Integer.toString(31417);
        this.refresh = Integer.toString(60);
        this.listener = null;
        this.sender = new Data();
    }

    @Override
    protected void createFrame() {
        super.createFrame();
        this.setConfirmExit(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.panelJobsTodo = new JPanel(new BorderLayout());
        this.panelJobsDone = new JPanel(new BorderLayout());
        this.panelJobsFailed = new JPanel(new BorderLayout());
        this.panelClients = new JPanel(new BorderLayout());
        this.panelPending = new JPanel(new BorderLayout());
        this.panelAdditional = new JPanel(new BorderLayout());
        this.listJobsTodo = new List();
        this.listJobsTodo.setPopupMenuEnabled(true);
        this.listJobsTodo.addMouseListener(this);
        this.listJobsTodo.setFont(Font.decode(this.getCustomFont()));
        this.listJobsDone = new List();
        this.listJobsDone.setPopupMenuEnabled(true);
        this.listJobsDone.addMouseListener(this);
        this.listJobsDone.setFont(Font.decode(this.getCustomFont()));
        this.listJobsFailed = new List();
        this.listJobsFailed.setPopupMenuEnabled(true);
        this.listJobsFailed.addMouseListener(this);
        this.listJobsFailed.setFont(Font.decode(this.getCustomFont()));
        this.listClients = new List();
        this.listClients.addMouseListener(this);
        this.listClients.setPopupMenuEnabled(true);
        this.listClients.setFont(Font.decode(this.getCustomFont()));
        this.listPending = new List();
        this.listPending.setPopupMenuEnabled(true);
        this.listPending.addMouseListener(this);
        this.listPending.setFont(Font.decode(this.getCustomFont()));
        this.listAdditional = new List();
        this.listAdditional.setPopupMenuEnabled(true);
        this.listAdditional.addMouseListener(this);
        this.listAdditional.setFont(Font.decode(this.getCustomFont()));
        this.paneJobsTodo = new JScrollPane(this.listJobsTodo);
        this.paneJobsDone = new JScrollPane(this.listJobsDone);
        this.paneJobsFailed = new JScrollPane(this.listJobsFailed);
        this.paneClients = new JScrollPane(this.listClients);
        this.panePending = new JScrollPane(this.listPending);
        this.paneAdditional = new JScrollPane(this.listAdditional);
        this.panelJobsTodo.add((Component)this.paneJobsTodo, "Center");
        this.panelJobsDone.add((Component)this.paneJobsDone, "Center");
        this.panelJobsFailed.add((Component)this.paneJobsFailed, "Center");
        this.panelClients.add((Component)this.paneClients, "Center");
        this.panelPending.add((Component)this.panePending, "Center");
        this.panelAdditional.add((Component)this.paneAdditional, "Center");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.addTab(TAB_TODO, ImageLoader.getImageIcon("run.gif"), this.panelJobsTodo);
        this.tabbedPane.addTab(TAB_DONE, ImageLoader.getImageIcon("stop.gif"), this.panelJobsDone);
        this.tabbedPane.addTab(TAB_FAILED, ImageLoader.getImageIcon("stop2.gif"), this.panelJobsFailed);
        this.tabbedPane.addTab(TAB_CLIENTS, ImageLoader.getImageIcon("computer.gif"), this.panelClients);
        this.tabbedPane.addTab(TAB_PENDING, ImageLoader.getImageIcon("project.gif"), this.panelPending);
        this.tabbedPane.addTab(TAB_ADDITIONAL, ImageLoader.getImageIcon("objects.gif"), this.panelAdditional);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.server = this.cl.getValue("server", this.server);
        this.port = this.cl.getValue("server_port", this.port);
        this.refresh = this.cl.getValue(ACTION_REFRESH, this.refresh);
        this.labelServer = new JLabel("Server");
        this.textServer = new JTextField(this.server, 20);
        this.labelPort = new JLabel("Port");
        this.textPort = new JTextField(this.port, 7);
        this.labelRefresh = new JLabel("Refresh");
        this.textRefresh = new JTextField(this.refresh, 4);
        this.textRefresh.getDocument().addDocumentListener(this);
        this.buttonConnect = new JButton("Connect", ImageLoader.getImageIcon("network.gif"));
        this.buttonConnect.setActionCommand(ACTION_CONNECT);
        this.buttonConnect.addActionListener(this);
        this.buttonShutdownServer = new JButton("Shutdown", ImageLoader.getImageIcon("trashcan.gif"));
        this.buttonShutdownServer.setActionCommand(ACTION_SHUTDOWNSERVER);
        this.buttonShutdownServer.addActionListener(this);
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(this.labelServer);
        panel.add(this.textServer);
        panel.add(this.labelPort);
        panel.add(this.textPort);
        panel.add(this.labelRefresh);
        panel.add(this.textRefresh);
        panel.add(this.buttonConnect);
        panel.add(this.buttonShutdownServer);
        this.getContentPane().add((Component)panel, "North");
        this.buttonRefresh = new JButton("Refresh", ImageLoader.getImageIcon("refresh.gif"));
        this.buttonRefresh.setActionCommand(ACTION_REFRESH);
        this.buttonRefresh.addActionListener(this);
        this.buttonExit = new JButton("Exit", ImageLoader.getImageIcon("forward.gif"));
        this.buttonExit.setActionCommand("exit");
        this.buttonExit.addActionListener(this);
        this.labelEntries = new JLabel("");
        this.labelEntries.setHorizontalAlignment(0);
        panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buttonRefresh, "West");
        panel.add((Component)this.labelEntries, "Center");
        panel.add((Component)this.buttonExit, "East");
        this.getContentPane().add((Component)panel, "South");
        this.showEntries();
        this.buttonDelete = new JButton("Delete", ImageLoader.getImageIcon("delete.gif"));
        this.buttonDelete.setActionCommand(ACTION_DELETE);
        this.buttonDelete.addActionListener(this);
        this.buttonAddJobs = new JButton("Add", ImageLoader.getImageIcon("open.gif"));
        this.buttonAddJobs.setActionCommand(ACTION_ADDJOBS);
        this.buttonAddJobs.addActionListener(this);
        this.buttonSaveJobs = new JButton("Save", ImageLoader.getImageIcon("save.gif"));
        this.buttonSaveJobs.setActionCommand(ACTION_SAVEJOBS);
        this.buttonSaveJobs.addActionListener(this);
        panel = new JPanel(new GridLayout(0, 1));
        panel.add(this.buttonDelete);
        panel.add(this.buttonAddJobs);
        panel.add(this.buttonSaveJobs);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)panel, "North");
        this.panelJobsTodo.add((Component)panel2, "East");
        this.buttonShell = new JButton("Shell", ImageLoader.getImageIcon("shell.gif"));
        this.buttonShell.setActionCommand(ACTION_SHELL);
        this.buttonShell.addActionListener(this);
        this.buttonShutdownClient = new JButton("Shutdown", ImageLoader.getImageIcon("trashcan.gif"));
        this.buttonShutdownClient.setActionCommand(ACTION_SHUTDOWNCLIENT);
        this.buttonShutdownClient.addActionListener(this);
        this.buttonKillClient = new JButton("Kill", ImageLoader.getImageIcon("stop2.gif"));
        this.buttonKillClient.setActionCommand(ACTION_KILLCLIENT);
        this.buttonKillClient.addActionListener(this);
        this.buttonReregisterClient = new JButton("Reregister", ImageLoader.getImageIcon("refresh.gif"));
        this.buttonReregisterClient.setActionCommand(ACTION_REREGISTERCLIENT);
        this.buttonReregisterClient.addActionListener(this);
        panel = new JPanel(new GridLayout(0, 1));
        panel.add(this.buttonShutdownClient);
        panel.add(this.buttonKillClient);
        panel.add(this.buttonReregisterClient);
        panel.add(this.buttonShell);
        panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)panel, "North");
        this.panelClients.add((Component)panel2, "East");
        this.fileChooser = new FileChooser(new File(System.getProperty("user.dir")));
        this.timer = new Timer(60000, true, false);
        this.timer.addListener(this);
    }

    @Override
    public void timerEvent(Timer t) {
        this.refreshLists();
    }

    private void changeTimer() {
        int time;
        try {
            time = Integer.parseInt(this.textRefresh.getText());
        }
        catch (Exception e) {
            time = -1;
        }
        if (time > 0) {
            this.timer.setInterval(time * 1000);
            if (this.timer.isRunning()) {
                this.timer.start();
            }
        } else {
            this.timer.stop();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        try {
            this.listener.setActive(false);
        }
        catch (Exception ex) {
            this.println(ex);
        }
        super.windowClosed(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.textRefresh.getDocument() == e.getDocument()) {
            this.changeTimer();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.textRefresh.getDocument() == e.getDocument()) {
            this.changeTimer();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.textRefresh.getDocument() == e.getDocument()) {
            this.changeTimer();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.showEntries();
    }

    private void showEntries() {
        JList list = null;
        int index = this.tabbedPane.getSelectedIndex();
        if (index > -1) {
            if (this.tabbedPane.getTitleAt(index).equals(TAB_TODO)) {
                list = this.listJobsTodo;
            } else if (this.tabbedPane.getTitleAt(index).equals(TAB_DONE)) {
                list = this.listJobsDone;
            } else if (this.tabbedPane.getTitleAt(index).equals(TAB_FAILED)) {
                list = this.listJobsFailed;
            } else if (this.tabbedPane.getTitleAt(index).equals(TAB_CLIENTS)) {
                list = this.listClients;
            } else if (this.tabbedPane.getTitleAt(index).equals(TAB_PENDING)) {
                list = this.listPending;
            } else if (this.tabbedPane.getTitleAt(index).equals(TAB_ADDITIONAL)) {
                list = this.listAdditional;
            }
        }
        int count = list == null ? 0 : list.getModel().getSize();
        if (this.labelEntries != null) {
            this.labelEntries.setText("Entries: " + count);
        }
    }

    private Message createMessage(String request) {
        Message result = new Message(Integer.parseInt(this.localPort));
        result.setType(request);
        return result;
    }

    private boolean sendToServer(String msg) {
        boolean result = true;
        try {
            result = this.sender.send(new InetSocketAddress(this.server, Integer.parseInt(this.port)), msg);
            if (!result) {
                this.println(this.sender.getLastException());
            }
        }
        catch (Exception e) {
            this.println(e);
            result = false;
        }
        return result;
    }

    private boolean getList(String request) {
        return this.sendToServer(this.createMessage(request).toString());
    }

    private void refreshSelectedList() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index == -1) {
            return;
        }
        if (this.tabbedPane.getTitleAt(index).equals(TAB_TODO)) {
            this.getList("jobs_todo");
        } else if (this.tabbedPane.getTitleAt(index).equals(TAB_DONE)) {
            this.getList("jobs_done");
        } else if (this.tabbedPane.getTitleAt(index).equals(TAB_FAILED)) {
            this.getList("jobs_failed");
        } else if (this.tabbedPane.getTitleAt(index).equals(TAB_CLIENTS)) {
            this.getList("clients");
        } else if (this.tabbedPane.getTitleAt(index).equals(TAB_PENDING)) {
            this.getList("pending");
        } else if (this.tabbedPane.getTitleAt(index).equals(TAB_ADDITIONAL)) {
            this.getList("additional");
        }
    }

    private void refreshLists() {
        this.serverIsAlive = true;
        this.getList("jobs_todo");
        if (this.serverIsAlive) {
            this.getList("jobs_done");
        }
        if (this.serverIsAlive) {
            this.getList("jobs_failed");
        }
        if (this.serverIsAlive) {
            this.getList("clients");
        }
        if (this.serverIsAlive) {
            this.getList("pending");
        }
        if (this.serverIsAlive) {
            this.getList("additional");
        }
    }

    public void setData(DataMessage msg) {
        if (msg == null) {
            return;
        }
        List list = null;
        if (msg.getType().equals("jobs_todo")) {
            list = this.listJobsTodo;
        } else if (msg.getType().equals("jobs_done")) {
            list = this.listJobsDone;
        } else if (msg.getType().equals("jobs_failed")) {
            list = this.listJobsFailed;
        } else if (msg.getType().equals("clients")) {
            list = this.listClients;
        } else if (msg.getType().equals("pending")) {
            list = this.listPending;
        } else if (msg.getType().equals("additional")) {
            list = this.listAdditional;
        }
        if (list != null) {
            Vector lines = msg.getLines();
            if (list == this.listClients || list == this.listPending || list == this.listAdditional) {
                Collections.sort(lines);
            }
            list.setListData(lines);
        }
        this.showEntries();
    }

    public void setServerIsAlive(boolean serverIsAlive) {
        this.serverIsAlive = serverIsAlive;
    }

    private boolean deleteEntry() {
        boolean result = true;
        ProperVector lines = new ProperVector();
        Object[] list = this.listJobsTodo.getSelectedValues();
        int[] indices = this.listJobsTodo.getSelectedIndices();
        int i = 0;
        while (i < list.length) {
            String line = String.valueOf(Integer.toString(indices[i])) + "\t" + list[i].toString();
            lines.add(line);
            ++i;
        }
        DataMessage msg = new DataMessage(this.createMessage(ACTION_DELETE));
        msg.setLines(lines);
        result = this.sendToServer(msg.toString());
        if (result) {
            result = this.getList("jobs_todo");
        }
        return result;
    }

    private void addJobs() {
        int retVal = this.fileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        JobAdder adder = new JobAdder();
        ProperVector args = new ProperVector();
        args.add("-server");
        args.add(this.textServer.getText());
        args.add("-port");
        args.add(this.textPort.getText());
        args.add("-jobs");
        args.add(this.fileChooser.getSelectedFile().getAbsolutePath());
        try {
            adder.run(Strings.vectorToArray(args));
        }
        catch (Exception e) {
            this.println(e);
        }
    }

    private void saveJobs() {
        int retVal = this.fileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        Object[] data = this.listJobsTodo.getListHelper().getAllListData();
        ProperVector list = new ProperVector();
        int i = 0;
        while (i < data.length) {
            list.add(data[i].toString());
            ++i;
        }
        TextFile.save(this.fileChooser.getSelectedFile().getAbsolutePath(), list);
    }

    private void setConnectButton() {
        if (this.timer.isRunning()) {
            this.buttonConnect.setText("Disconnect");
        } else {
            this.buttonConnect.setText("Connect");
        }
    }

    private void connectToServer() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        } else {
            this.timer.start();
            this.refreshLists();
        }
        this.setConnectButton();
    }

    private boolean shutdownServer() {
        Message msg = this.createMessage("shutdown");
        boolean result = this.sendToServer(msg.toString());
        this.timer.stop();
        this.setConnectButton();
        return result;
    }

    private boolean sendMessageToClients(Message msg) {
        boolean result = true;
        Object[] list = this.listClients.getSelectedValues();
        int i = 0;
        while (i < list.length) {
            Address addr = new Address((String)list[i]);
            boolean ok = true;
            try {
                ok = this.sender.send(new InetSocketAddress(addr.getIPStr(), addr.getPort()), msg.toString());
                if (!ok) {
                    this.println(this.sender.getLastException());
                }
            }
            catch (Exception e) {
                this.println(e);
                ok = false;
            }
            result = result && ok;
            ++i;
        }
        return result;
    }

    private boolean shutdownClient() {
        return this.sendMessageToClients(this.createMessage("shutdown"));
    }

    private boolean killClient() {
        return this.sendMessageToClients(this.createMessage("kill"));
    }

    private boolean reregisterClient() {
        EditDialog dialog = new EditDialog(this, "Client-List...");
        dialog.setEditable(true);
        dialog.show();
        if (!dialog.approved()) {
            return true;
        }
        Vector lines = Strings.breakUpVector(dialog.getText(), "\n");
        if (lines.size() == 0) {
            return true;
        }
        DataMessage msg = new DataMessage(this.createMessage("reregister"));
        msg.setLines(lines);
        return this.sendToServer(msg.toString());
    }

    private void startShell() {
        Shell shell = new Shell(this.cl.getValue(ACTION_SHELL), false);
        if (shell.lastException() != null) {
            this.println(shell.lastException());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("exit")) {
            this.dispose();
        } else if (action.equals(ACTION_REFRESH)) {
            this.refreshSelectedList();
        } else if (action.equals(ACTION_DELETE)) {
            this.deleteEntry();
        } else if (action.equals(ACTION_ADDJOBS)) {
            this.addJobs();
        } else if (action.equals(ACTION_SAVEJOBS)) {
            this.saveJobs();
        } else if (action.equals(ACTION_CONNECT)) {
            this.connectToServer();
        } else if (action.equals(ACTION_SHUTDOWNSERVER)) {
            this.shutdownServer();
        } else if (action.equals(ACTION_SHUTDOWNCLIENT)) {
            this.shutdownClient();
        } else if (action.equals(ACTION_KILLCLIENT)) {
            this.killClient();
        } else if (action.equals(ACTION_REREGISTERCLIENT)) {
            this.reregisterClient();
        } else if (action.equals(ACTION_SHELL)) {
            this.startShell();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        List list;
        int index;
        if (e.getComponent() instanceof List && (index = (list = (List)e.getComponent()).locationToIndex(e.getPoint())) > -1 && e.getClickCount() == 2) {
            e.consume();
            EditDialog dialog = new EditDialog(this, "View");
            dialog.setText(list.getModel().getElementAt(index).toString());
            dialog.show();
        }
    }

    @Override
    protected boolean afterCreate() {
        this.localPort = this.cl.getValue("port", this.localPort);
        this.listener = new JobListener(this, Integer.parseInt(this.localPort));
        return true;
    }

    @Override
    public void printDescription() {
        System.out.println("A Tool for monitoring a JobServer.");
        System.out.println();
    }

    @Override
    public void printUsage() {
        super.printUsage();
        System.out.println(" -port <int> (optional)");
        System.out.println("  the port to bind to, default is " + this.localPort);
        System.out.println(" -server <hostname/IP> (optional)");
        System.out.println("  the server to retrieve jobs from, default is " + this.server);
        System.out.println(" -server_port <int> (optional)");
        System.out.println("  the port to bind to, default is " + this.port);
        System.out.println(" -refresh <int> (optional)");
        System.out.println("  the refresh interval in seconds (0 = never), default is " + this.refresh);
        System.out.println(" -shell <command> (optional)");
        System.out.println("  a command that can be executed on the client-tab via the 'Shell'-Button");
    }

    public static void main(String[] args) throws Exception {
        JobMonitor frame = new JobMonitor(null);
        frame.run(args);
    }
}

