/*
 * Decompiled with CFR 0.152.
 */
package proper.imp;

import java.util.Date;
import proper.core.ProperObject;
import proper.util.ProperVector;

public class Fingerprint
extends ProperObject
implements Comparable {
    public static final String STRING = "java.lang.String";
    public static final String INTEGER = "java.lang.Integer";
    public static final String LONG = "java.lang.Long";
    public static final String DOUBLE = "java.lang.Double";
    public static final String DATE = "java.util.Date";
    public static final String SQL_DATE = "java.sql.Date";
    public static final String LIST = "proper.imp.List";
    public static final String PREDICATE = "proper.imp.Predicate";
    public static final String NULL = "NULL";
    private static final int RANK_PREDICATE = 6;
    private static final int RANK_LIST = 5;
    private static final int RANK_DATE = 4;
    private static final int RANK_STRING = 3;
    private static final int RANK_DOUBLE = 2;
    private static final int RANK_LONG = 1;
    private static final int RANK_INTEGER = 0;
    private static final int RANK_NULL = -1;
    private Object value;

    public Fingerprint(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNull() {
        return Fingerprint.isNull(this.value);
    }

    public static boolean isNull(Object value) {
        return value.toString().equals(NULL);
    }

    public int compareTo(Object o) throws ClassCastException {
        int result = 0;
        Fingerprint fp = (Fingerprint)o;
        int rank1 = Fingerprint.getClassRank(this);
        int rank2 = Fingerprint.getClassRank(fp);
        result = rank1 == -1 || rank2 == -1 ? 0 : (rank1 < rank2 ? -1 : (rank1 == rank2 ? 0 : 1));
        return result;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    private static int getClassRank(Fingerprint fp) {
        String name = fp.toString();
        int result = name.equals(STRING) && fp.getValue().equals(NULL) ? -1 : (name.equals(INTEGER) ? 0 : (name.equals(LONG) ? 1 : (name.equals(DOUBLE) ? 2 : (name.equals(DATE) || name.equals(SQL_DATE) ? 4 : (name.equals(LIST) ? 5 : (name.equals(PREDICATE) ? 6 : 3))))));
        return result;
    }

    public String getSuperClass(Object o) {
        return Fingerprint.getSuperClass(this.getValue(), o);
    }

    public String getSuperClass(Fingerprint fp) {
        return Fingerprint.getSuperClass(this.getValue(), fp.getValue());
    }

    public static String getSuperClass(Fingerprint fp1, Fingerprint fp2) {
        return Fingerprint.getSuperClass(fp1.getValue(), fp2.getValue());
    }

    public static String getSuperClass(Object o1, Object o2) {
        int rank;
        String result;
        Fingerprint fp1 = new Fingerprint(o1);
        Fingerprint fp2 = new Fingerprint(o2);
        if (Fingerprint.getClassRank(fp1) > Fingerprint.getClassRank(fp2)) {
            result = fp1.toString();
            rank = Fingerprint.getClassRank(fp1);
        } else {
            result = fp2.toString();
            rank = Fingerprint.getClassRank(fp2);
        }
        if (rank >= 3) {
            result = STRING;
        }
        return result;
    }

    @Override
    public String toString() {
        return this.value.getClass().getName();
    }

    public static void main(String[] args) {
        ProperVector fp = new ProperVector();
        fp.add(new Fingerprint(new Integer(2)));
        fp.add(new Fingerprint(new Long(1000L)));
        fp.add(new Fingerprint(new Double(3.1415)));
        fp.add(new Fingerprint(new Date()));
        fp.add(new Fingerprint(new String(NULL)));
        int i = 0;
        while (i < fp.size() - 1) {
            Fingerprint fp1 = (Fingerprint)fp.get(i);
            int n = i;
            while (n < fp.size()) {
                Fingerprint fp2 = (Fingerprint)fp.get(n);
                System.out.println(String.valueOf(fp1.getValue().toString()) + " == " + fp2.getValue().toString() + ": " + fp1.compareTo(fp2));
                System.out.println(String.valueOf(fp1.getValue().toString()) + " + " + fp2.getValue().toString() + " = " + fp1.getSuperClass(fp2));
                ++n;
            }
            ++i;
        }
    }
}

