/*
 * Decompiled with CFR 0.152.
 */
package proper.io;

import java.util.Vector;
import proper.util.Strings;

public class CommandLineParameter {
    private String name;
    private String description;
    private boolean optional;
    private boolean hasArgument;
    private String argDesc;
    private int indention;

    public CommandLineParameter(String name, String description) {
        this(name, description, false, null, false);
    }

    public CommandLineParameter(String name, String description, boolean hasArgument, String argDesc, boolean optional) {
        this.name = name;
        this.description = description;
        this.hasArgument = hasArgument;
        this.argDesc = argDesc == null || argDesc.equals("") ? "<arg>" : argDesc;
        this.optional = optional;
        this.indention = 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.equals("");
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasArgument() {
        return this.hasArgument;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setIndention(int indention) {
        if (indention >= 0) {
            this.indention = indention;
        }
    }

    public int getIndention() {
        return this.indention;
    }

    public String toString() {
        String result = "";
        String indent = Strings.stringOf(" ", this.getIndention());
        result = String.valueOf(indent) + "-" + this.getName();
        if (this.hasArgument()) {
            result = String.valueOf(result) + " " + this.argDesc;
        }
        if (this.isOptional()) {
            result = String.valueOf(result) + " (optional)";
        }
        if (this.hasDescription()) {
            Vector lines = Strings.breakUpVector(this.getDescription(), "\n");
            int i = 0;
            while (i < lines.size()) {
                result = String.valueOf(result) + "\n " + indent + lines.get(i);
                ++i;
            }
        }
        return result;
    }

    public static void main(String[] args) {
        CommandLineParameter param = new CommandLineParameter("bla", "");
        System.out.println(param + "\n");
        param = new CommandLineParameter("bla", "no description");
        System.out.println(param + "\n");
        param = new CommandLineParameter("bla", "something", true, "", false);
        System.out.println(param + "\n");
        param = new CommandLineParameter("bla", "something else", true, null, true);
        param.setIndention(2);
        System.out.println(param + "\n");
    }
}

