/*
 * Decompiled with CFR 0.152.
 */
package proper.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class CopyFile {
    public static boolean copy(String from, String to) {
        boolean result = false;
        FileInputStream input = null;
        FileOutputStream output = null;
        File source = null;
        try {
            try {
                input = new FileInputStream(from);
                output = new FileOutputStream(to);
                source = new File(from);
                int fileLength = (int)source.length();
                byte[] byteBuff = new byte[fileLength];
                while (input.read(byteBuff, 0, fileLength) != -1) {
                    output.write(byteBuff, 0, fileLength);
                }
                result = true;
            }
            catch (FileNotFoundException e) {
                System.out.println(String.valueOf(from) + " does not exist!");
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                System.out.println("Error reading/writing files!");
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Command Syntax: " + CopyFile.class.getName() + " <source> <dest>");
            System.out.println();
            System.out.println("<source>\tThe source file name (path optional)");
            System.out.println("<dest>\t\tThe destination file name (path optional)");
            System.out.println();
            System.exit(1);
        } else {
            boolean result = CopyFile.copy(args[0], args[1]);
            System.out.println("Copying " + args[0] + " to " + args[1] + " = " + result);
        }
    }
}

