/*
 * Decompiled with CFR 0.152.
 */
package proper.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Shell {
    private Process child;
    private String command;
    private String error;
    private String output;
    private Exception exception;

    public Shell() {
        this.child = null;
        this.error = "";
        this.command = "";
        this.exception = null;
    }

    public Shell(String cmd) {
        this(cmd, true);
    }

    public Shell(String cmd, boolean wait) {
        this.execute(cmd, wait);
    }

    public int execute(String cmd) {
        return this.execute(cmd, true);
    }

    public int execute(String cmd, boolean wait) {
        this.command = cmd;
        this.error = "";
        this.exception = null;
        int result = -1;
        try {
            this.child = Runtime.getRuntime().exec(this.command);
            result = wait ? this.child.waitFor() : 0;
            this.getLastStdout();
            this.getLastStderr();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exception = e;
        }
        return result;
    }

    private String getLastOutput(InputStream is) {
        String result = "";
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while (br.ready()) {
                String line;
                if (!result.equals("")) {
                    result = String.valueOf(result) + "\n";
                }
                if ((line = br.readLine()) == null) continue;
                result = String.valueOf(result) + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void getLastStderr() {
        this.error = this.getLastOutput(this.child.getErrorStream());
    }

    private void getLastStdout() {
        this.output = this.getLastOutput(this.child.getInputStream());
    }

    public String lastStdout() {
        return this.output;
    }

    public String lastStderr() {
        return this.error;
    }

    public String lastCommand() {
        return this.command;
    }

    public Exception lastException() {
        return this.exception;
    }

    public static void main(String[] args) {
        Shell shell = args.length > 0 ? new Shell(args[0]) : new Shell("ls *1");
        System.out.println("last Command: " + shell.lastCommand());
        System.out.println("last stdout: " + shell.lastStdout());
        System.out.println("last stderr: " + shell.lastStderr());
    }
}

