/*
 * Decompiled with CFR 0.152.
 */
package proper.io;

import java.io.PrintStream;
import java.util.Vector;
import proper.util.ProperVector;
import proper.util.Timestamp;

public class Tee {
    private Vector streams = new ProperVector();
    private Vector timestamps = new ProperVector();

    public Tee() {
        this.clear();
    }

    public void clear() {
        this.streams.clear();
        this.timestamps.clear();
        this.add(System.out);
    }

    public void add(PrintStream p) {
        this.add(p, false);
    }

    public void add(PrintStream p, boolean timestamp) {
        if (this.streams.contains(p)) {
            this.remove(p);
        }
        this.streams.add(p);
        this.timestamps.add(new Boolean(timestamp));
    }

    public PrintStream get(int index) {
        if (index >= 0 && index < this.size()) {
            return (PrintStream)this.streams.get(index);
        }
        return null;
    }

    public PrintStream remove(PrintStream p) {
        if (this.contains(p)) {
            int index = this.streams.indexOf(p);
            this.timestamps.remove(index);
            return (PrintStream)this.streams.remove(index);
        }
        return null;
    }

    public PrintStream remove(int index) {
        if (index >= 0 && index < this.size()) {
            this.timestamps.remove(index);
            return (PrintStream)this.streams.remove(index);
        }
        return null;
    }

    public boolean contains(PrintStream p) {
        return this.streams.contains(p);
    }

    public int size() {
        return this.streams.size();
    }

    private void printTimestamp() {
        int i = 0;
        while (i < this.size()) {
            if (((Boolean)this.timestamps.get(i)).booleanValue()) {
                ((PrintStream)this.streams.get(i)).print(new Timestamp());
            }
            ++i;
        }
    }

    public void flush() {
        int i = 0;
        while (i < this.size()) {
            ((PrintStream)this.streams.get(i)).flush();
            ++i;
        }
    }

    public void print(int x) {
        this.printTimestamp();
        int i = 0;
        while (i < this.size()) {
            ((PrintStream)this.streams.get(i)).print(x);
            ++i;
        }
        this.flush();
    }

    public void print(boolean x) {
        this.printTimestamp();
        int i = 0;
        while (i < this.size()) {
            ((PrintStream)this.streams.get(i)).print(x);
            ++i;
        }
        this.flush();
    }

    public void print(String x) {
        this.printTimestamp();
        int i = 0;
        while (i < this.size()) {
            ((PrintStream)this.streams.get(i)).print(x);
            ++i;
        }
        this.flush();
    }

    public void print(Object x) {
        this.printTimestamp();
        int i = 0;
        while (i < this.size()) {
            ((PrintStream)this.streams.get(i)).print(x);
            ++i;
        }
        this.flush();
    }

    public void println() {
        this.printTimestamp();
        int i = 0;
        while (i < this.size()) {
            ((PrintStream)this.streams.get(i)).println();
            ++i;
        }
        this.flush();
    }

    public void println(int x) {
        this.printTimestamp();
        int i = 0;
        while (i < this.size()) {
            ((PrintStream)this.streams.get(i)).println(x);
            ++i;
        }
        this.flush();
    }

    public void println(boolean x) {
        this.printTimestamp();
        int i = 0;
        while (i < this.size()) {
            ((PrintStream)this.streams.get(i)).println(x);
            ++i;
        }
        this.flush();
    }

    public void println(String x) {
        this.printTimestamp();
        int i = 0;
        while (i < this.size()) {
            ((PrintStream)this.streams.get(i)).println(x);
            ++i;
        }
        this.flush();
    }

    public void println(Object x) {
        int i;
        if (x instanceof Throwable) {
            Throwable t = (Throwable)x;
            StackTraceElement[] trace = t.getStackTrace();
            String line = String.valueOf(t.toString()) + "\n";
            i = 0;
            while (i < trace.length) {
                line = String.valueOf(line) + "\t" + trace[i].toString() + "\n";
                ++i;
            }
            x = line;
        }
        this.printTimestamp();
        i = 0;
        while (i < this.size()) {
            ((PrintStream)this.streams.get(i)).println(x);
            ++i;
        }
        this.flush();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.streams.size();
    }
}

