/*
 * Decompiled with CFR 0.152.
 */
package proper.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;
import proper.util.ProperVector;

public class TextFile {
    private String filename;

    public TextFile(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public Vector load() {
        return this.load();
    }

    public static Vector load(String filename) {
        ProperVector result = new ProperVector();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            while (reader.ready()) {
                result.add(reader.readLine());
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            result.clear();
        }
        return result;
    }

    public boolean save(Vector lines) {
        return TextFile.save(this.filename, lines);
    }

    public static boolean save(String filename, Vector lines) {
        return TextFile.save(filename, lines, false);
    }

    public boolean save(Vector lines, boolean append) {
        return TextFile.save(this.filename, lines, append);
    }

    public static boolean save(String filename, Vector lines, boolean append) {
        boolean result = true;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename, append));
            int i = 0;
            while (i < lines.size()) {
                writer.write(lines.get(i).toString());
                writer.newLine();
                ++i;
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }
}

