/*
 * Decompiled with CFR 0.152.
 */
package proper.remote;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import proper.app.Application;
import proper.io.TextFile;
import proper.net.Data;
import proper.remote.ClientList;
import proper.remote.Processor;
import proper.remote.messages.Message;
import proper.util.ProperVector;
import proper.util.Timestamp;

public abstract class Server
extends Application {
    public static final String REQUEST_NOP = "nop";
    public static final String REQUEST_ISALIVE = "is_alive";
    public static final int LIST_CLIENTS = 0;
    public static final int ALIVE_CHECK = 30000;
    protected int defaultPort;
    protected ServerSocket server = null;
    protected Message msg;
    protected ClientList clients = new ClientList();
    protected Data sender = new Data();
    protected String errorLog;
    protected String accessLog;
    protected boolean leaveLogs;
    protected int acceptTimeout;
    protected boolean hadClients = false;

    @Override
    protected void defaultParameters() {
        super.defaultParameters();
        this.defaultPort = 10000;
        this.errorLog = "errors.log";
        this.accessLog = "access.log";
        this.leaveLogs = false;
        this.acceptTimeout = 30000;
    }

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("port", "the port to bind to, default is " + this.defaultPort, true, "<int>", true);
        this.addDefinition("error_log", "the file to write errors to, default is " + this.errorLog, true, "<filename>", true);
        this.addDefinition("access_log", "the file to write accesses to, default is " + this.accessLog, true, "<filename>", true);
        this.addDefinition("leave_logs", "doesn't delete the logs when the server starts, default: " + this.leaveLogs, false, "", true);
        this.addDefinition("accept_timeout", "the timeout in msec to wait for a connection, default: " + this.acceptTimeout, true, "<int>", true);
    }

    public int getPort() {
        return this.defaultPort;
    }

    public String getHostName() {
        String host = "";
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            host = this.server.getInetAddress().getCanonicalHostName();
        }
        return host;
    }

    protected void addToLog(String log, String msg) {
        ProperVector lines = new ProperVector();
        lines.add((new Timestamp() + msg).toString());
        TextFile.save(log, lines, true);
    }

    public void addToErrorLog(String msg) {
        this.addToLog(this.errorLog, msg);
    }

    public void addToAccessLog(String msg) {
        this.addToLog(this.accessLog, msg);
    }

    public Message createMessage() {
        return new Message(this.getHostName(), this.getPort());
    }

    public Message createMessage(String request) {
        Message msg = this.createMessage();
        msg.setType(request);
        return msg;
    }

    protected String getRequest() {
        return this.msg.getType();
    }

    protected boolean isAlive(InetSocketAddress addr) {
        Message msg = this.createMessage();
        msg.setType(REQUEST_ISALIVE);
        return this.sender.send(addr, msg.toString(), true);
    }

    public void checkClients() {
        if (this.clients.size() > 0) {
            this.hadClients = true;
        }
        int i = 0;
        while (i < this.clients.size()) {
            InetSocketAddress addr = this.clients.get(i);
            if (!this.isAlive(addr)) {
                this.beforeRemoveClient(this.clients.get(i), this.clients);
                this.clients.remove(i);
                String msg = addr + " removed from clients.";
                this.addToErrorLog(msg);
                this.println(msg);
                continue;
            }
            if (this.getVerbose()) {
                this.println(addr + " is still alive.");
            }
            ++i;
        }
        this.afterCheckClients();
    }

    protected void beforeRemoveClient(InetSocketAddress client, ClientList list) {
    }

    protected void afterCheckClients() {
        if (this.hadClients && this.clients.size() == 0) {
            String msg = "WARNING: no more clients!";
            this.addToErrorLog(msg);
            this.println(msg);
        }
    }

    public ClientList getClientList(int type) {
        if (type == 0) {
            return this.clients;
        }
        return null;
    }

    protected void deleteLogs() {
        try {
            File file = new File(this.accessLog);
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(this.errorLog)).exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean startup() {
        boolean result;
        int port = this.defaultPort;
        try {
            port = this.cl.exists("port") ? Integer.parseInt(this.cl.getValue("port")) : this.defaultPort;
            if (this.cl.exists("error_log")) {
                this.errorLog = this.cl.getValue("error_log");
            }
            if (this.cl.exists("access_log")) {
                this.accessLog = this.cl.getValue("access_log");
            }
            if (!this.leaveLogs) {
                this.deleteLogs();
            }
            if (this.cl.exists("accept_timeout")) {
                this.acceptTimeout = Integer.parseInt(this.cl.getValue("accept_timeout"));
            }
            this.defaultPort = port;
            this.server = new ServerSocket(this.defaultPort);
            this.server.setSoTimeout(this.acceptTimeout);
            result = true;
        }
        catch (Exception e) {
            this.println(e);
            result = false;
        }
        if (result) {
            String msg = "Running on port " + this.server.getLocalPort();
            this.addToAccessLog(msg);
            this.println(msg);
        } else {
            String msg = "Failed to initialize on port " + port;
            this.addToErrorLog(msg);
            this.println(msg);
        }
        return result;
    }

    public boolean isOperational() {
        return true;
    }

    protected void beforeAccept() {
    }

    protected void afterAccept(Socket client) {
        String msg = "Request from: " + client;
        this.addToAccessLog(msg);
        if (this.getVerbose()) {
            this.println(msg);
        }
    }

    protected abstract Processor createProcessor(Socket var1);

    protected boolean execute() {
        boolean result = this.isOperational();
        while (this.isOperational()) {
            try {
                Socket client;
                this.beforeAccept();
                try {
                    client = this.server.accept();
                }
                catch (SocketTimeoutException se) {
                    this.checkClients();
                    continue;
                }
                this.afterAccept(client);
                Processor proc = this.createProcessor(client);
                proc.initialize();
                proc.start();
            }
            catch (Exception e) {
                this.println(e);
            }
        }
        return result;
    }

    protected void shutdown() {
    }

    @Override
    protected boolean process() throws Exception {
        boolean result = this.startup();
        if (result) {
            result = this.execute();
        }
        this.shutdown();
        return result;
    }
}

