/*
 * Decompiled with CFR 0.152.
 */
package proper.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Vector;
import proper.util.ProperVector;
import proper.xml.Element;
import proper.xml.Parser;

public class Document
implements Cloneable {
    private String pi;
    private String doctype;
    private Element root;
    private boolean validate;
    private Vector errors;
    private Vector warnings;

    public Document() {
        this.clear();
        this.validate = false;
        this.errors = new ProperVector();
        this.warnings = new ProperVector();
    }

    public Document(String pi) {
        this();
        this.setPI(pi);
    }

    public Document(String pi, Element root) {
        this();
        this.pi = pi;
        this.root = root;
    }

    public Document(Document doc) {
        this.setValidate(doc.getValidate());
        this.read(new StringReader(doc.toString()));
    }

    public Object clone() {
        return new Document(this);
    }

    public void clear() {
        this.pi = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        this.doctype = "";
        this.root = new Element("root");
        this.root.setIsContainer(true);
    }

    public void setPI(String pi) {
        this.pi = pi;
    }

    public String getPI() {
        return this.pi;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setRoot(Element root) {
        this.root = root;
        this.root.setIsContainer(true);
    }

    public Element getRoot() {
        return this.root;
    }

    public Vector getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public Vector getWarnings() {
        return this.warnings;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public boolean write(String filename) {
        boolean result;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            result = this.write(writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public boolean write(Writer writer) {
        boolean result;
        try {
            writer.write(this.toString());
            writer.write("\n");
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public boolean read(String filename) {
        boolean result;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            result = this.read(reader);
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public boolean read(Reader reader) {
        Parser parser = new Parser();
        parser.setValidate(this.getValidate());
        parser.parse(reader);
        this.errors = parser.getErrors();
        this.warnings = parser.getWarnings();
        boolean result = parser.getRoot() != null && !this.hasErrors();
        this.clear();
        this.setPI(parser.getPI());
        this.getRoot().add(parser.getRoot());
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.getPI() != null && !this.getPI().equals("")) {
            result.append(String.valueOf(this.getPI()) + "\n\n");
        }
        if (this.getDoctype() != null && !this.getDoctype().equals("")) {
            result.append(String.valueOf(this.getDoctype().trim()) + "\n\n");
        }
        result.append(this.getRoot().getChildAt(0).toString());
        return result.toString();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Document doc = new Document();
            doc.setRoot(new Element("message"));
            doc.getRoot().add(new Element("job"));
            System.out.println("\n" + doc);
            doc.setPI("<?xml version=\"1.0\"?>");
            System.out.println("\n" + doc);
        } else if (args.length == 1) {
            Document doc = new Document();
            doc.read(args[0]);
            System.out.println(doc);
        }
    }
}

