/*
 * Decompiled with CFR 0.152.
 */
package proper.xml;

import java.io.FileReader;
import java.io.Reader;
import java.util.Vector;
import milk.core.Exemplars;
import proper.xml.Attribute;
import proper.xml.Document;
import proper.xml.Element;
import proper.xml.Path;
import proper.xml.XMLInstances;
import weka.core.Instances;

public class XMLExemplars {
    public static final String DOCTYPE = "<!DOCTYPE relation [\n   <!ELEMENT relation (attributes, instances)>\n   <!ATTLIST relation name CDATA #REQUIRED>\n   <!ATTLIST relation timestamp CDATA #IMPLIED>\n   <!ELEMENT attributes (attribute+)>\n   <!ELEMENT attribute (value*)>\n   <!ATTLIST attribute name CDATA #REQUIRED>\n   <!ATTLIST attribute type (date | nominal | numeric | string) #REQUIRED>\n   <!ATTLIST attribute bag (yes | no) \"no\">\n   <!ATTLIST attribute class (yes | no) \"no\">\n   <!ELEMENT instances (instance*)>\n   <!ELEMENT instance (value+)>\n   <!ELEMENT value (#PCDATA)>\n]>\n";
    private Exemplars exemplars = null;
    private XMLInstances xmlinstances = new XMLInstances();

    public XMLExemplars() {
    }

    public XMLExemplars(Exemplars exemplars) {
        this();
        this.setExemplars(exemplars);
    }

    public XMLExemplars(Instances instances) {
        this();
        this.setInstances(instances);
    }

    public void setExemplars(Exemplars exemplars) {
        this.exemplars = exemplars;
    }

    public void setInstances(Instances instances) {
        Exemplars exemplars;
        if (instances.classIndex() == -1) {
            instances.setClassIndex(instances.numAttributes() - 1);
        }
        try {
            exemplars = new Exemplars(instances);
        }
        catch (Exception e) {
            e.printStackTrace();
            exemplars = null;
        }
        this.setExemplars(exemplars);
    }

    public Exemplars getExemplars() {
        return this.exemplars;
    }

    public void setDoctype(String doctype) {
        this.xmlinstances.setDoctype(doctype);
    }

    public String getDoctype() {
        return this.xmlinstances.getDoctype();
    }

    public void setPI(String pi) {
        this.xmlinstances.setPI(pi);
    }

    public String getPI() {
        return this.xmlinstances.getPI();
    }

    public void setDateFormat(String dateFormat) {
        this.xmlinstances.setDateFormat(dateFormat);
    }

    public String getDateFormat() {
        return this.xmlinstances.getDateFormat();
    }

    public static int stringToType(String typeStr) {
        return XMLInstances.stringToType(typeStr);
    }

    public static String typeToString(int type) {
        return XMLInstances.typeToString(type);
    }

    public Document process(Exemplars exemplars) {
        Vector nodes;
        Document result = null;
        Element root = null;
        Path path = new Path();
        if (exemplars == null) {
            return result;
        }
        int i = 0;
        while (i < exemplars.numExemplars()) {
            Document doc = this.xmlinstances.process(exemplars.exemplar(i).getInstances());
            if (i == 0) {
                result = new Document(doc);
                root = (Element)path.get(result.getRoot(), "//instances").get(0);
            } else {
                nodes = path.get(doc.getRoot(), "//instance");
                int n = 0;
                while (n < nodes.size()) {
                    root.add((Element)nodes.get(n));
                    ++n;
                }
            }
            ++i;
        }
        int id = exemplars.idIndex();
        if (id == -1) {
            id = 0;
        }
        nodes = path.get(root, "//attribute");
        ((Element)nodes.get(id)).addAttribute(new Attribute("bag", "yes"));
        return result;
    }

    public Exemplars process(Document doc) {
        Exemplars result;
        if (doc == null) {
            return null;
        }
        int id = 0;
        Path path = new Path();
        Vector nodes = path.get(doc.getRoot(), "//attribute");
        int i = 0;
        while (i < nodes.size()) {
            Element node = (Element)nodes.get(i);
            if (node.getAttribute("bag") != null && node.getAttribute("bag").getValue().equals("yes")) {
                id = i;
                break;
            }
            ++i;
        }
        try {
            result = new Exemplars(this.xmlinstances.process(doc), id);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public boolean write(String filename) {
        Document doc = this.process(this.getExemplars());
        doc.setPI(this.getPI());
        doc.setDoctype(this.getDoctype());
        return doc.write(filename);
    }

    public static boolean write(String filename, Exemplars exemplars) {
        return new XMLExemplars(exemplars).write(filename);
    }

    public static boolean write(String filename, Instances instances) {
        return new XMLExemplars(instances).write(filename);
    }

    public boolean read(String filename) {
        Document doc = new Document();
        boolean result = doc.read(filename);
        if (result) {
            this.exemplars = this.process(doc);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("\n" + XMLExemplars.class.getName() + " <xml | arff> <filename>\n");
            System.exit(1);
        }
        XMLExemplars xexemp = new XMLExemplars();
        Exemplars exemp = null;
        if (args[0].equals("xml")) {
            if (!xexemp.read(args[1])) throw new Exception("Error reading '" + args[1] + "'");
            exemp = xexemp.getExemplars();
        } else if (args[0].equals("arff")) {
            Instances inst = new Instances((Reader)new FileReader(args[1]));
            if (inst.classIndex() == -1) {
                inst.setClassIndex(inst.numAttributes() - 1);
            }
            exemp = new Exemplars(inst);
        }
        System.out.println(exemp);
        if (exemp == null) return;
        XMLExemplars.write(String.valueOf(args[1]) + ".xml", exemp);
    }
}

