#!/bin/bash

# this script does some filtering on a given logfile
#
# $Revision: 1.2 $
# FracPete

# the usage of this script
function usage()
{
   echo 
   echo "usage: ${0##*/} -f <filtertype> -l <logfile> -a <additional> [-h]"
   echo 
   echo "filters logfiles after certain criteria"
   echo 
   echo " -h   this help"
   echo " -f   <filertype>"
   echo "      Current type(s):"
   echo "      sql      filters Create/Join/Alter/Drop statements"
   echo "      host     filters all entries from the given  host"
   echo "               the hostname has to be provided with '-a'"
   echo "      grep     does a simple grep for the string provided"
   echo "               with '-a'"
   echo " -l   <logfile>"
   echo "      the logfile to use"
   echo " -a   <additional>"
   echo "      additional parameters, depending on the filtertype"
   echo
}

FILTER="grep"
LOGFILE=""

# interprete parameters
while getopts ":hf:l:a:" flag
do
   case $flag in
      f) FILTER=$OPTARG
         ;;
      l) LOGFILE=$OPTARG
         ;;
      a) ADDITIONAL=$OPTARG
         ;;
      h) usage
         exit 0
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# SQL filtering
if [ "$FILTER" = "sql" ]
then
   cat $LOGFILE | grep -i "Create\|Join\|Index\|Drop\|Alter" | sed s/.*"\[java\]"//g | sed s/.*"Create: \|Join: \|Index: \|Drop: \|Alter: "//g | sed s/" = true\| = false"//g | sed s/"$"/";"/g | sed s/"\[".*"\] "//g
fi

# host filtering
if [ "$FILTER" = "host" ]
then
   cat $LOGFILE \| grep "\[$ADDITIONAL\]" \| sed s/.*"\[java\]"//g \| sed s/.*"\[$ADDITIONAL\] "//g
fi

# simple grep
if [ "$FILTER" = "grep" ]
then
   cat $LOGFILE | grep "$ADDITIONAL" | sed s/.*"\[java\]"//g | sed s/.*"\[$ADDITIONAL\] "//g
fi

