/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { NpmConfig } from "projen/lib/javascript";
import { TypeScriptProject, TypeScriptProjectOptions } from "projen/lib/typescript";
/**
 * Configuration for the generated typescript client project
 */
export interface GeneratedTypescriptClientProjectOptions extends TypeScriptProjectOptions {
    /**
     * The absolute path to the OpenAPI specification (spec.yaml) from which to generate code
     */
    readonly specPath: string;
}
/**
 * Typescript project containing a typescript client (and lambda handler wrappers) generated using OpenAPI Generator CLI
 */
export declare class GeneratedTypescriptClientProject extends TypeScriptProject {
    /**
     * A reference to the npm config (generated for PNPM projects)
     */
    readonly npmConfig?: NpmConfig;
    private synthed;
    constructor(options: GeneratedTypescriptClientProjectOptions);
    /**
     * @inheritDoc
     */
    synth(): void;
}
