"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoRollback = void 0;
const crypto_1 = require("crypto");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_sqs_1 = require("aws-cdk-lib/aws-sqs");
const constructs_1 = require("constructs");
const autorollback_function_1 = require("./autorollback-function");
class AutoRollback extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const lambdaTimeout = aws_cdk_lib_1.Duration.minutes(15);
        const pollQueue = new aws_sqs_1.Queue(this, 'PollQueue', {
            visibilityTimeout: lambdaTimeout,
        });
        const lambdaFunction = new autorollback_function_1.AutorollbackFunction(this, 'Handler');
        lambdaFunction.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: ['cloudwatch:DescribeAlarms'],
            resources: ['*'],
            effect: aws_iam_1.Effect.ALLOW,
        }));
        const alarmDescription = `[${props.name ?? ''}-${aws_cdk_lib_1.Names.uniqueResourceName(this, { separator: '-' })}]`;
        new aws_cloudwatch_1.CompositeAlarm(this, 'composite-alarm', {
            compositeAlarmName: props.name,
            alarmRule: props.alarmRule,
            alarmDescription,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: lambdaFunction,
            isCompleteHandler: lambdaFunction,
        });
        new aws_cdk_lib_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                monitoringTime: props.monitoringTime,
                searchTerms: alarmDescription,
                queueUrl: pollQueue.queueUrl,
                nonce: crypto_1.randomUUID(),
            },
        });
    }
}
exports.AutoRollback = AutoRollback;
//# sourceMappingURL=data:application/json;base64,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