import { IRole } from 'aws-cdk-lib/aws-iam';
import { IBucket } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * Options for creating a calendar object.
 */
export interface CalendarLocationOptionsBase {
    /**
     * The name of the calendar file.
     */
    readonly calendarName: string;
}
/**
 * Options for creating a calendar from a local file path
 */
export interface LocalPathOptions extends CalendarLocationOptionsBase {
    /**
     * The relative path to the calendar file.
     */
    readonly calendarPath: string;
}
/**
 * Options for creating a calendar from a file in a S3 Bucket.
 */
export interface S3LocationOptions extends CalendarLocationOptionsBase {
    /**
     * The bucket where the calendar is stored.
     */
    readonly bucket: IBucket;
    /**
     * The role used for getting the calendar file.
     */
    readonly role?: IRole;
}
/**
 * The source types for the calendar file.
 */
export declare enum CalendarSourceType {
    /**
     * The calendar source is an S3 Bucket.
     */
    S3_OBJECT = "s3Object",
    /**
     * The calendar source is a local path.
     */
    PATH = "path"
}
/**
 * The calendar for determining if pipeline stage should be open or closed.
 */
export declare abstract class Calendar {
    static path(options: LocalPathOptions): Calendar;
    static s3Location(options: S3LocationOptions): Calendar;
    calendarName: string;
    calendarArn: string;
    protected constructor();
    /**
     *
     * @internal
     */
    abstract _bind(scope: Construct): any;
}
