"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Calendar = exports.CalendarSourceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const calendar_setup_function_1 = require("./calendar-setup-function");
/**
 * The source types for the calendar file.
 */
var CalendarSourceType;
(function (CalendarSourceType) {
    /**
     * The calendar source is an S3 Bucket.
     */
    CalendarSourceType["S3_OBJECT"] = "s3Object";
    /**
     * The calendar source is a local path.
     */
    CalendarSourceType["PATH"] = "path";
})(CalendarSourceType = exports.CalendarSourceType || (exports.CalendarSourceType = {}));
/**
 * The calendar for determining if pipeline stage should be open or closed.
 */
class Calendar {
    constructor() { }
    static path(options) {
        return new (class extends Calendar {
            _bind(scope) {
                const calendarBody = fs.readFileSync(path.join(options.calendarPath, options.calendarName), { encoding: 'utf-8' });
                const calendar = new CustomResourceCalendar(scope, {
                    sourceType: CalendarSourceType.PATH,
                    calendarBody,
                    calendarName: options.calendarName,
                });
                this.calendarArn = calendar.calendarArn;
                this.calendarName = calendar.calendarName;
                return calendar;
            }
        })();
    }
    static s3Location(options) {
        return new (class extends Calendar {
            _bind(scope) {
                const calendar = new CustomResourceCalendar(scope, {
                    sourceType: CalendarSourceType.S3_OBJECT,
                    bucketName: options.bucket.bucketName,
                    calendarName: options.calendarName,
                    roleArn: options.role?.roleArn,
                });
                this.calendarArn = calendar.calendarArn;
                this.calendarName = calendar.calendarName;
                return calendar;
            }
        })();
    }
}
exports.Calendar = Calendar;
_a = JSII_RTTI_SYMBOL_1;
Calendar[_a] = { fqn: "@cdklabs/cdk-codepipeline-extensions.Calendar", version: "0.0.7" };
/**
 * The custom resource for getting the calendar and uploading it to SSM.
 */
class CustomResourceCalendar extends Calendar {
    constructor(scope, options) {
        super();
        this.calendarName = options.calendarName;
        this.calendarArn = aws_cdk_lib_1.Arn.format({
            service: 'ssm',
            resource: 'document',
            resourceName: options.calendarName,
        }, aws_cdk_lib_1.Stack.of(scope));
        const onEvent = new calendar_setup_function_1.CalendarSetupFunction(scope, 'OnEventHandler');
        onEvent.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: [
                'ssm:CreateDocument',
                'ssm:UpdateDocument',
                'ssm:DeleteDocument',
            ],
            resources: [this.calendarArn],
        }));
        const provider = new custom_resources_1.Provider(scope, 'Provider', {
            onEventHandler: onEvent,
        });
        new aws_cdk_lib_1.CustomResource(scope, 'SSMCalendarCustomResource', {
            serviceToken: provider.serviceToken,
            properties: {
                sourceType: options.sourceType,
                calendarBody: options.calendarBody,
                bucketName: options.bucketName,
                calendarName: options.calendarName,
                roleArn: options.roleArn,
            },
        });
    }
    _bind() { }
}
//# sourceMappingURL=data:application/json;base64,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