# SPDX-FileCopyrightText: 2021 ladyada for Adafruit Industries
# SPDX-License-Identifier: MIT

# adafruit_requests usage with a CPython socket
import socket
import adafruit_requests

http = adafruit_requests.Session(socket)

TEXT_URL = "http://wifitest.adafruit.com/testwifi/index.html"
JSON_GET_URL = "http://httpbin.org/get"
JSON_POST_URL = "http://httpbin.org/post"
REDIRECT_URL = "http://httpbingo.org/redirect/1"
RELATIVE_REDIRECT_URL = "http://httpbingo.org/relative-redirect/1"
ABSOLUTE_REDIRECT_URL = "http://httpbingo.org/absolute-redirect/1"

print("Fetching text from %s" % TEXT_URL)
response = http.get(TEXT_URL)
print("-" * 40)

print("Text Response: ", response.text)
print("-" * 40)

print("Fetching JSON data from %s" % JSON_GET_URL)
response = http.get(JSON_GET_URL)
print("-" * 40)

print("JSON Response: ", response.json())
print("-" * 40)
response.close()

data = "31F"
print("POSTing data to {0}: {1}".format(JSON_POST_URL, data))
response = http.post(JSON_POST_URL, data=data)
print("-" * 40)

json_resp = response.json()
# Parse out the 'data' key from json_resp dict.
print("Data received from server:", json_resp["data"])
print("-" * 40)

json_data = {"Date": "July 25, 2019"}
print("POSTing data to {0}: {1}".format(JSON_POST_URL, json_data))
response = http.post(JSON_POST_URL, json=json_data)
print("-" * 40)

json_resp = response.json()
# Parse out the 'json' key from json_resp dict.
print("JSON Data received from server:", json_resp["json"])
print("-" * 40)

print("Fetching JSON data from redirect url %s" % REDIRECT_URL)
response = http.get(REDIRECT_URL)
print("-" * 40)

print("JSON Response: ", response.json())
print("-" * 40)

print("Fetching JSON data from relative redirect url %s" % RELATIVE_REDIRECT_URL)
response = http.get(RELATIVE_REDIRECT_URL)
print("-" * 40)

print("JSON Response: ", response.json())
print("-" * 40)

print("Fetching JSON data from aboslute redirect url %s" % ABSOLUTE_REDIRECT_URL)
response = http.get(ABSOLUTE_REDIRECT_URL)
print("-" * 40)

print("JSON Response: ", response.json())
print("-" * 40)

response.close()
