# -*- coding: utf-8 -*-
#
# This file was automatically generated.
#
from datetime import datetime
from typing import Optional

from .amount_data import AmountData
from .api_references_for_responses import ApiReferencesForResponses
from .card_payment_data_for_response import CardPaymentDataForResponse

from worldline.acquiring.sdk.domain.data_object import DataObject


class ApiPaymentResponse(DataObject):

    __card_payment_data: Optional[CardPaymentDataForResponse] = None
    __initial_authorization_code: Optional[str] = None
    __operation_id: Optional[str] = None
    __payment_id: Optional[str] = None
    __references: Optional[ApiReferencesForResponses] = None
    __responder: Optional[str] = None
    __response_code: Optional[str] = None
    __response_code_category: Optional[str] = None
    __response_code_description: Optional[str] = None
    __retry_after: Optional[str] = None
    __status: Optional[str] = None
    __status_timestamp: Optional[datetime] = None
    __total_authorized_amount: Optional[AmountData] = None

    @property
    def card_payment_data(self) -> Optional[CardPaymentDataForResponse]:
        """
        Type: :class:`worldline.acquiring.sdk.v1.domain.card_payment_data_for_response.CardPaymentDataForResponse`
        """
        return self.__card_payment_data

    @card_payment_data.setter
    def card_payment_data(self, value: Optional[CardPaymentDataForResponse]) -> None:
        self.__card_payment_data = value

    @property
    def initial_authorization_code(self) -> Optional[str]:
        """
        | Authorization approval code

        Type: str
        """
        return self.__initial_authorization_code

    @initial_authorization_code.setter
    def initial_authorization_code(self, value: Optional[str]) -> None:
        self.__initial_authorization_code = value

    @property
    def operation_id(self) -> Optional[str]:
        """
        | A globally unique identifier of the operation, generated by you.
        | We advise you to submit a UUID or an identifier composed of an arbitrary string and a UUID/URL-safe Base64 UUID (RFC 4648 §5).
        | It's used to detect duplicate requests or to reference an operation in technical reversals.

        Type: str
        """
        return self.__operation_id

    @operation_id.setter
    def operation_id(self, value: Optional[str]) -> None:
        self.__operation_id = value

    @property
    def payment_id(self) -> Optional[str]:
        """
        | the ID of the payment

        Type: str
        """
        return self.__payment_id

    @payment_id.setter
    def payment_id(self, value: Optional[str]) -> None:
        self.__payment_id = value

    @property
    def references(self) -> Optional[ApiReferencesForResponses]:
        """
        | A set of references returned in responses

        Type: :class:`worldline.acquiring.sdk.v1.domain.api_references_for_responses.ApiReferencesForResponses`
        """
        return self.__references

    @references.setter
    def references(self, value: Optional[ApiReferencesForResponses]) -> None:
        self.__references = value

    @property
    def responder(self) -> Optional[str]:
        """
        | The party that originated the response

        Type: str
        """
        return self.__responder

    @responder.setter
    def responder(self, value: Optional[str]) -> None:
        self.__responder = value

    @property
    def response_code(self) -> Optional[str]:
        """
        | Numeric response code, e.g. 0000, 0005

        Type: str
        """
        return self.__response_code

    @response_code.setter
    def response_code(self, value: Optional[str]) -> None:
        self.__response_code = value

    @property
    def response_code_category(self) -> Optional[str]:
        """
        | Category of response code.

        Type: str
        """
        return self.__response_code_category

    @response_code_category.setter
    def response_code_category(self, value: Optional[str]) -> None:
        self.__response_code_category = value

    @property
    def response_code_description(self) -> Optional[str]:
        """
        | Description of the response code

        Type: str
        """
        return self.__response_code_description

    @response_code_description.setter
    def response_code_description(self, value: Optional[str]) -> None:
        self.__response_code_description = value

    @property
    def retry_after(self) -> Optional[str]:
        """
        | The duration to wait after the initial submission before retrying the payment.
        | Expressed using ISO 8601 duration format, ex: PT2H for 2 hours.
        | This field is only present when the payment can be retried later.
        | PT0 means that the payment can be retried immediately.

        Type: str
        """
        return self.__retry_after

    @retry_after.setter
    def retry_after(self, value: Optional[str]) -> None:
        self.__retry_after = value

    @property
    def status(self) -> Optional[str]:
        """
        | The status of the payment, refund or credit transfer

        Type: str
        """
        return self.__status

    @status.setter
    def status(self, value: Optional[str]) -> None:
        self.__status = value

    @property
    def status_timestamp(self) -> Optional[datetime]:
        """
        | Timestamp of the status in format yyyy-MM-ddTHH:mm:ssZ

        Type: datetime
        """
        return self.__status_timestamp

    @status_timestamp.setter
    def status_timestamp(self, value: Optional[datetime]) -> None:
        self.__status_timestamp = value

    @property
    def total_authorized_amount(self) -> Optional[AmountData]:
        """
        | Amount for the operation.

        Type: :class:`worldline.acquiring.sdk.v1.domain.amount_data.AmountData`
        """
        return self.__total_authorized_amount

    @total_authorized_amount.setter
    def total_authorized_amount(self, value: Optional[AmountData]) -> None:
        self.__total_authorized_amount = value

    def to_dictionary(self) -> dict:
        dictionary = super(ApiPaymentResponse, self).to_dictionary()
        if self.card_payment_data is not None:
            dictionary['cardPaymentData'] = self.card_payment_data.to_dictionary()
        if self.initial_authorization_code is not None:
            dictionary['initialAuthorizationCode'] = self.initial_authorization_code
        if self.operation_id is not None:
            dictionary['operationId'] = self.operation_id
        if self.payment_id is not None:
            dictionary['paymentId'] = self.payment_id
        if self.references is not None:
            dictionary['references'] = self.references.to_dictionary()
        if self.responder is not None:
            dictionary['responder'] = self.responder
        if self.response_code is not None:
            dictionary['responseCode'] = self.response_code
        if self.response_code_category is not None:
            dictionary['responseCodeCategory'] = self.response_code_category
        if self.response_code_description is not None:
            dictionary['responseCodeDescription'] = self.response_code_description
        if self.retry_after is not None:
            dictionary['retryAfter'] = self.retry_after
        if self.status is not None:
            dictionary['status'] = self.status
        if self.status_timestamp is not None:
            dictionary['statusTimestamp'] = DataObject.format_datetime(self.status_timestamp)
        if self.total_authorized_amount is not None:
            dictionary['totalAuthorizedAmount'] = self.total_authorized_amount.to_dictionary()
        return dictionary

    def from_dictionary(self, dictionary: dict) -> 'ApiPaymentResponse':
        super(ApiPaymentResponse, self).from_dictionary(dictionary)
        if 'cardPaymentData' in dictionary:
            if not isinstance(dictionary['cardPaymentData'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['cardPaymentData']))
            value = CardPaymentDataForResponse()
            self.card_payment_data = value.from_dictionary(dictionary['cardPaymentData'])
        if 'initialAuthorizationCode' in dictionary:
            self.initial_authorization_code = dictionary['initialAuthorizationCode']
        if 'operationId' in dictionary:
            self.operation_id = dictionary['operationId']
        if 'paymentId' in dictionary:
            self.payment_id = dictionary['paymentId']
        if 'references' in dictionary:
            if not isinstance(dictionary['references'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['references']))
            value = ApiReferencesForResponses()
            self.references = value.from_dictionary(dictionary['references'])
        if 'responder' in dictionary:
            self.responder = dictionary['responder']
        if 'responseCode' in dictionary:
            self.response_code = dictionary['responseCode']
        if 'responseCodeCategory' in dictionary:
            self.response_code_category = dictionary['responseCodeCategory']
        if 'responseCodeDescription' in dictionary:
            self.response_code_description = dictionary['responseCodeDescription']
        if 'retryAfter' in dictionary:
            self.retry_after = dictionary['retryAfter']
        if 'status' in dictionary:
            self.status = dictionary['status']
        if 'statusTimestamp' in dictionary:
            self.status_timestamp = DataObject.parse_datetime(dictionary['statusTimestamp'])
        if 'totalAuthorizedAmount' in dictionary:
            if not isinstance(dictionary['totalAuthorizedAmount'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['totalAuthorizedAmount']))
            value = AmountData()
            self.total_authorized_amount = value.from_dictionary(dictionary['totalAuthorizedAmount'])
        return self
