# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- Project information -----------------------------------------------------

project = 'sphinxcontrib-git-context-test'
copyright = '2020, sphinxcontrib-git-context-test'
author = 'sphinxcontrib-git-context-test'

# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinxcontrib.git_context',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'alabaster'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

version = 'default_version'
release = 'default_release'


def custom_git_context_setup(config):
    git_context = config['git_context']
    generated_at = git_context['generated_at']
    commit_date = git_context['commit_date']
    commit_tags = git_context['commit_tags']
    commit_hash = git_context['commit_hash']
    dirty = git_context['dirty']
    config['version'] = f'commit_tags="{", ".join(commit_tags)}" commit_date="{commit_date}"'
    config['release'] = f'generated_at="{generated_at}" commit_hash="{commit_hash}" dirty="{dirty}"'


git_context_setup = custom_git_context_setup
