"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBStreamsToLambdaToElasticSearchAndKibana = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_dynamodbstreams_lambda_1 = require("@aws-solutions-constructs/aws-dynamodbstreams-lambda");
const aws_lambda_elasticsearch_kibana_1 = require("@aws-solutions-constructs/aws-lambda-elasticsearch-kibana");
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
class DynamoDBStreamsToLambdaToElasticSearchAndKibana extends constructs_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the LambdaToDynamoDB class.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        const _props1 = {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            dynamoEventSourceProps: props.dynamoEventSourceProps,
            dynamoTableProps: props.dynamoTableProps,
            existingTableInterface: props.existingTableInterface,
            deploySqsDlqQueue: props.deploySqsDlqQueue,
            sqsDlqQueueProps: props.sqsDlqQueueProps
        };
        this.DynamoDBStreamsToLambda = new aws_dynamodbstreams_lambda_1.DynamoDBStreamsToLambda(this, 'DynamoDBStreamsToLambda', _props1);
        this.lambdaFunction = this.DynamoDBStreamsToLambda.lambdaFunction;
        const _props2 = {
            existingLambdaObj: this.lambdaFunction,
            domainName: props.domainName,
            esDomainProps: props.esDomainProps,
            cognitoDomainName: props.cognitoDomainName,
            createCloudWatchAlarms: props.createCloudWatchAlarms
        };
        this.lambdaToElasticSearchAndKibana = new aws_lambda_elasticsearch_kibana_1.LambdaToElasticSearchAndKibana(this, 'LambdaToElasticSearch', _props2);
        this.dynamoTable = this.DynamoDBStreamsToLambda.dynamoTable;
        this.dynamoTableInterface = this.DynamoDBStreamsToLambda.dynamoTableInterface;
        this.userPool = this.lambdaToElasticSearchAndKibana.userPool;
        this.userPoolClient = this.lambdaToElasticSearchAndKibana.userPoolClient;
        this.identityPool = this.lambdaToElasticSearchAndKibana.identityPool;
        this.elasticsearchDomain = this.lambdaToElasticSearchAndKibana.elasticsearchDomain;
        this.elasticsearchRole = this.lambdaToElasticSearchAndKibana.elasticsearchRole;
        this.cloudwatchAlarms = this.lambdaToElasticSearchAndKibana.cloudwatchAlarms;
    }
}
exports.DynamoDBStreamsToLambdaToElasticSearchAndKibana = DynamoDBStreamsToLambdaToElasticSearchAndKibana;
_a = JSII_RTTI_SYMBOL_1;
DynamoDBStreamsToLambdaToElasticSearchAndKibana[_a] = { fqn: "@aws-solutions-constructs/aws-dynamodbstreams-lambda-elasticsearch-kibana.DynamoDBStreamsToLambdaToElasticSearchAndKibana", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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