/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.util;

import com.datapps.linkoopdb.jdbc.util.Traceable;
import com.datapps.linkoopdb.jdbc.util.TransferDb;
import com.datapps.linkoopdb.jdbc.util.TransferHelper;
import com.datapps.linkoopdb.jdbc.util.TransferTable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class HsqldbTransferHelper
extends TransferHelper {
    public HsqldbTransferHelper() {
    }

    public HsqldbTransferHelper(TransferDb database, Traceable t, String q) {
        super(database, t, q);
    }

    @Override
    int convertFromType(int type) {
        if (type == 100) {
            type = 12;
            this.tracer.trace("Converted LinkoopDB VARCHAR_IGNORECASE to VARCHAR");
        }
        return type;
    }

    @Override
    String fixupColumnDefRead(TransferTable t, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        String CompareString = "INTEGER IDENTITY";
        if (columnType.indexOf(CompareString) >= 0) {
            columnType = "SERIAL";
        }
        return columnType;
    }

    @Override
    String fixupColumnDefWrite(TransferTable t, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        if (columnType.indexOf("SERIAL") >= 0) {
            columnType = "INTEGER GENERATED BY DEFAULT AS IDENTITY";
        }
        return columnType;
    }

    @Override
    String fixupColumnDefRead(String aTableName, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        return this.fixupColumnDefRead((TransferTable)null, meta, columnType, columnDesc, columnIndex);
    }

    @Override
    String fixupColumnDefWrite(String aTableName, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        return this.fixupColumnDefWrite((TransferTable)null, meta, columnType, columnDesc, columnIndex);
    }

    @Override
    String formatName(String t) {
        return this.formatIdentifier(t);
    }
}

