/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib;

import com.datapps.linkoopdb.jdbc.lib.Collection;
import com.datapps.linkoopdb.jdbc.lib.Iterator;
import com.datapps.linkoopdb.jdbc.lib.Set;
import com.datapps.linkoopdb.jdbc.map.BaseHashMap;

public class OrderedIntKeyHashMap
extends BaseHashMap {
    Set keySet;
    Collection values;

    public OrderedIntKeyHashMap() {
        this(8);
    }

    public OrderedIntKeyHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 1, 3, false);
        this.isList = true;
    }

    public int getKey(int lookup, int def) {
        if (lookup >= 0 && lookup < this.size()) {
            return this.intKeyTable[lookup];
        }
        return def;
    }

    public Object getValue(int lookup) {
        if (lookup >= 0 && lookup < this.size()) {
            return this.objectValueTable[lookup];
        }
        return null;
    }

    public Object get(int key) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.objectValueTable[lookup];
        }
        return null;
    }

    public Object put(int key, Object value) {
        return super.addOrRemove(key, value, null, false);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public Object remove(int key) {
        int lookup = this.getLookup(key);
        if (lookup < 0) {
            return null;
        }
        Object returnValue = super.addOrRemove(key, null, null, true);
        this.removeRow(lookup);
        return returnValue;
    }

    public Object removeKeyAndValue(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return this.remove(this.intKeyTable[index]);
    }

    @Override
    public boolean containsKey(int key) {
        return super.containsKey(key);
    }

    public void valuesToArray(Object[] array) {
        Iterator it = this.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            array[i] = it.next();
            ++i;
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            OrderedIntKeyHashMap orderedIntKeyHashMap = OrderedIntKeyHashMap.this;
            orderedIntKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(orderedIntKeyHashMap, false);
        }

        @Override
        public int size() {
            return OrderedIntKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            OrderedIntKeyHashMap.this.clear();
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            OrderedIntKeyHashMap orderedIntKeyHashMap = OrderedIntKeyHashMap.this;
            orderedIntKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(orderedIntKeyHashMap, true);
        }

        @Override
        public int size() {
            return OrderedIntKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            OrderedIntKeyHashMap.this.clear();
        }
    }
}

