import { Component } from "projen";
import { PythonProject } from "projen/lib/python";
/**
 * Configuration for the GeneratedPythonClient component
 */
export interface GeneratedPythonClientSourceCodeOptions {
    /**
     * Absolute path to the OpenAPI specification (spec.yaml)
     */
    readonly specPath: string;
    /**
     * Control if generator needs to be invoked
     */
    readonly invokeGenerator: boolean;
}
/**
 * Generates the python client using OpenAPI Generator
 */
export declare class GeneratedPythonClientSourceCode extends Component {
    private options;
    constructor(project: PythonProject, options: GeneratedPythonClientSourceCodeOptions);
    /**
     * @inheritDoc
     */
    synthesize(): void;
}
