"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocumentationFormat = exports.ClientLanguage = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * Supported languages for client generation
 */
var ClientLanguage;
(function (ClientLanguage) {
    ClientLanguage["TYPESCRIPT"] = "typescript";
    ClientLanguage["PYTHON"] = "python";
    ClientLanguage["JAVA"] = "java";
})(ClientLanguage = exports.ClientLanguage || (exports.ClientLanguage = {}));
/**
 * Formats for documentation generation
 */
var DocumentationFormat;
(function (DocumentationFormat) {
    /**
     * HTML Documentation generated by redoc
     * @see https://github.com/Redocly/redoc
     */
    DocumentationFormat["HTML_REDOC"] = "html_redoc";
    /**
     * OpenAPI Generator 'html2' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/html2.md
     */
    DocumentationFormat["HTML2"] = "html2";
    /**
     * OpenAPI Generator 'markdown' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/markdown.md
     */
    DocumentationFormat["MARKDOWN"] = "markdown";
    /**
     * OpenAPI Generator 'plantuml' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/plantuml.md
     */
    DocumentationFormat["PLANTUML"] = "plantuml";
})(DocumentationFormat = exports.DocumentationFormat || (exports.DocumentationFormat = {}));
//# sourceMappingURL=data:application/json;base64,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