# splitit-async

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.6.6
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.
Python 3.4+ 


## Installation & Usage

Install the version published on pypi:
```sh
python3 -m pip install splitit_async
```

Then import the package:
```python
import splitit_async
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:
```python
import asyncio
from pprint import pprint

import splitit_async
from splitit_async.rest import ApiException

async def create_plan(api_client):
    try:
        # Perform request
        api_response = await api_client.InstallmentPlanApi.installment_plan_create(
            splitit_async.CreateInstallmentPlanRequest(
                plan_data=splitit_async.PlanData(
                    auto_capture=True,
                    amount=splitit_async.MoneyWithCurrencyCode(600, "USD"),
                    number_of_installments=3,
                    ref_order_number="abc123",
                ),
                billing_address=splitit_async.AddressData2(
                    address_line="260 Madison Avenue.",
                    city="New York",
                    state="NY",
                    country="USA",
                    zip="10016",
                ),
                consumer_data=splitit_async.ConsumerData(
                    full_name="John Smith",
                    email="JohnS@splitit_async.com",
                    phone_number="1-415-775-4848",
                    culture_name="en-us",
                ),
                credit_card_details=splitit_async.CardData(
                    card_holder_full_name="John Smith",
                    card_number="4111111111111111",
                    card_exp_year="2022",
                    card_exp_month="8",
                    card_cvv="123",
                ),
                plan_approval_evidence=splitit_async.PlanApprovalEvidence(
                    are_terms_and_conditions_approved=True,
                ),
            )
        )

        pprint(api_response)
    except ApiException as e:
        print("Exception when calling CreateInstallmentPlanApi->installment_plan_create: %s\n" % e)

async def main():
    # Configure the API client:
    api_client = splitit_async.ApiClient(splitit_async.Configuration('YOUR_USERNAME', 'YOUR_PASSWORD', 'YOUR_API_KEY', sandbox=True))
    async with api_client:
        await create_plan(api_client)

if __name__ == "__main__":
    asyncio.run(main())

```

## Documentation for API Endpoints

All URIs are relative to *https://webapi.production.splitit.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CreateInstallmentPlanApi* | [**create_installment_plan_get**](docs/CreateInstallmentPlanApi.md#create_installment_plan_get) | **GET** /api/CreateInstallmentPlan | 
*InfoApi* | [**info_get_learn_more_details**](docs/InfoApi.md#info_get_learn_more_details) | **POST** /api/Merchant/GetLearnMoreDetails | 
*InfrastructureApi* | [**infrastructure_get_resources**](docs/InfrastructureApi.md#infrastructure_get_resources) | **POST** /api/Infrastructure/GetResources | 
*InfrastructureApi* | [**infrastructure_get_resources2**](docs/InfrastructureApi.md#infrastructure_get_resources2) | **GET** /api/Infrastructure/GetResources | 
*InstallmentPlanApi* | [**installment_plan_approve**](docs/InstallmentPlanApi.md#installment_plan_approve) | **POST** /api/InstallmentPlan/Approve | 
*InstallmentPlanApi* | [**installment_plan_cancel**](docs/InstallmentPlanApi.md#installment_plan_cancel) | **POST** /api/InstallmentPlan/Cancel | 
*InstallmentPlanApi* | [**installment_plan_charge_back**](docs/InstallmentPlanApi.md#installment_plan_charge_back) | **POST** /api/InstallmentPlan/ChargeBack | 
*InstallmentPlanApi* | [**installment_plan_create**](docs/InstallmentPlanApi.md#installment_plan_create) | **POST** /api/InstallmentPlan/Create | 
*InstallmentPlanApi* | [**installment_plan_get**](docs/InstallmentPlanApi.md#installment_plan_get) | **POST** /api/InstallmentPlan/Get | 
*InstallmentPlanApi* | [**installment_plan_get3_d_secure_parameters**](docs/InstallmentPlanApi.md#installment_plan_get3_d_secure_parameters) | **POST** /api/InstallmentPlan/Get3DSecureParameters | 
*InstallmentPlanApi* | [**installment_plan_get_extended**](docs/InstallmentPlanApi.md#installment_plan_get_extended) | **POST** /api/InstallmentPlan/GetExtended | 
*InstallmentPlanApi* | [**installment_plan_get_fraud_status_display**](docs/InstallmentPlanApi.md#installment_plan_get_fraud_status_display) | **POST** /api/InstallmentPlan/GetFraudStatusDisplay | 
*InstallmentPlanApi* | [**installment_plan_get_initiated_installment_plan_request**](docs/InstallmentPlanApi.md#installment_plan_get_initiated_installment_plan_request) | **POST** /api/InstallmentPlan/GetInitiatedInstallmentPlanRequest | 
*InstallmentPlanApi* | [**installment_plan_get_initiated_update_payment_data**](docs/InstallmentPlanApi.md#installment_plan_get_initiated_update_payment_data) | **GET** /api/InstallmentPlan/GetInitiatedUpdatePaymentData | 
*InstallmentPlanApi* | [**installment_plan_get_learn_more_details**](docs/InstallmentPlanApi.md#installment_plan_get_learn_more_details) | **POST** /api/InstallmentPlan/GetLearnMoreDetails | 
*InstallmentPlanApi* | [**installment_plan_get_pgtl**](docs/InstallmentPlanApi.md#installment_plan_get_pgtl) | **POST** /api/InstallmentPlan/GetPGTL | 
*InstallmentPlanApi* | [**installment_plan_get_schedules**](docs/InstallmentPlanApi.md#installment_plan_get_schedules) | **POST** /api/InstallmentPlan/GetSchedules | 
*InstallmentPlanApi* | [**installment_plan_initiate**](docs/InstallmentPlanApi.md#installment_plan_initiate) | **POST** /api/InstallmentPlan/Initiate | 
*InstallmentPlanApi* | [**installment_plan_refund**](docs/InstallmentPlanApi.md#installment_plan_refund) | **POST** /api/InstallmentPlan/Refund | 
*InstallmentPlanApi* | [**installment_plan_start_installments**](docs/InstallmentPlanApi.md#installment_plan_start_installments) | **POST** /api/InstallmentPlan/StartInstallments | 
*InstallmentPlanApi* | [**installment_plan_terms_and_conditions**](docs/InstallmentPlanApi.md#installment_plan_terms_and_conditions) | **POST** /api/InstallmentPlan/TermsAndConditions | 
*InstallmentPlanApi* | [**installment_plan_test_card**](docs/InstallmentPlanApi.md#installment_plan_test_card) | **POST** /api/InstallmentPlan/TestCard | 
*InstallmentPlanApi* | [**installment_plan_update**](docs/InstallmentPlanApi.md#installment_plan_update) | **POST** /api/InstallmentPlan/Update | 
*InstallmentPlanApi* | [**installment_plan_verify_payment**](docs/InstallmentPlanApi.md#installment_plan_verify_payment) | **POST** /api/InstallmentPlan/Get/VerifyPayment | 
*LoginApi* | [**login_post**](docs/LoginApi.md#login_post) | **POST** /api/Login | 


## Documentation For Models

 - [AccountUpdaterProvider](docs/AccountUpdaterProvider.md)
 - [AccountingParty](docs/AccountingParty.md)
 - [AddressData2](docs/AddressData2.md)
 - [AgentFeeType](docs/AgentFeeType.md)
 - [AmountDetails2](docs/AmountDetails2.md)
 - [ApproveInstallmentPlanRequest](docs/ApproveInstallmentPlanRequest.md)
 - [AuthenticationType](docs/AuthenticationType.md)
 - [BankDetails](docs/BankDetails.md)
 - [BinData](docs/BinData.md)
 - [BusinessActivity](docs/BusinessActivity.md)
 - [BusinessParty](docs/BusinessParty.md)
 - [CancelInstallmentPlanRequest](docs/CancelInstallmentPlanRequest.md)
 - [CardBrand](docs/CardBrand.md)
 - [CardData](docs/CardData.md)
 - [CardResult](docs/CardResult.md)
 - [CardType](docs/CardType.md)
 - [CartData](docs/CartData.md)
 - [ChargebackRequest](docs/ChargebackRequest.md)
 - [ChbDefaultAction](docs/ChbDefaultAction.md)
 - [CountryState](docs/CountryState.md)
 - [CreateInstallmentPlanLegacyResponse](docs/CreateInstallmentPlanLegacyResponse.md)
 - [CreateInstallmentPlanRequest](docs/CreateInstallmentPlanRequest.md)
 - [CurrencyCountries](docs/CurrencyCountries.md)
 - [DelayResolution](docs/DelayResolution.md)
 - [EntityBase](docs/EntityBase.md)
 - [Error](docs/Error.md)
 - [EventsEndpoints](docs/EventsEndpoints.md)
 - [ExternalAuth](docs/ExternalAuth.md)
 - [FailureUnderFrozenInstallmentsPlan](docs/FailureUnderFrozenInstallmentsPlan.md)
 - [FeesTypes](docs/FeesTypes.md)
 - [FraudCheck](docs/FraudCheck.md)
 - [FraudCheckResult](docs/FraudCheckResult.md)
 - [FundingTransferReason](docs/FundingTransferReason.md)
 - [Get3DSecureParametersRequest](docs/Get3DSecureParametersRequest.md)
 - [Get3DSecureParametersResponse](docs/Get3DSecureParametersResponse.md)
 - [GetFraudStatusDisplayRequest](docs/GetFraudStatusDisplayRequest.md)
 - [GetFraudStatusDisplayResponse](docs/GetFraudStatusDisplayResponse.md)
 - [GetInitiatedInstallmentPlanRequest](docs/GetInitiatedInstallmentPlanRequest.md)
 - [GetInitiatedInstallmentPlanResponse](docs/GetInitiatedInstallmentPlanResponse.md)
 - [GetInitiatedUpdatePaymentDataResponse](docs/GetInitiatedUpdatePaymentDataResponse.md)
 - [GetInstallmentSchedulesRequest](docs/GetInstallmentSchedulesRequest.md)
 - [GetInstallmentsPlanResponse](docs/GetInstallmentsPlanResponse.md)
 - [GetInstallmentsPlanSearchCriteriaRequest](docs/GetInstallmentsPlanSearchCriteriaRequest.md)
 - [GetInstallmentsScheduleResponse](docs/GetInstallmentsScheduleResponse.md)
 - [GetPGTLRequest](docs/GetPGTLRequest.md)
 - [GetPGTLResponse](docs/GetPGTLResponse.md)
 - [GetResourcesRequest](docs/GetResourcesRequest.md)
 - [GetResourcesRequestContext](docs/GetResourcesRequestContext.md)
 - [GetResourcesResponse](docs/GetResourcesResponse.md)
 - [IUserPasswordHistory](docs/IUserPasswordHistory.md)
 - [InitiateInstallmentPlanRequest](docs/InitiateInstallmentPlanRequest.md)
 - [Installment](docs/Installment.md)
 - [Installment2](docs/Installment2.md)
 - [InstallmentPaymentGatewayTransactionLogs](docs/InstallmentPaymentGatewayTransactionLogs.md)
 - [InstallmentPlan](docs/InstallmentPlan.md)
 - [InstallmentPlanActivityStatus](docs/InstallmentPlanActivityStatus.md)
 - [InstallmentPlanCancelationReason](docs/InstallmentPlanCancelationReason.md)
 - [InstallmentPlanDateInfo](docs/InstallmentPlanDateInfo.md)
 - [InstallmentPlanEventType](docs/InstallmentPlanEventType.md)
 - [InstallmentPlanInitiatedStatuses](docs/InstallmentPlanInitiatedStatuses.md)
 - [InstallmentPlanQueryCriteria](docs/InstallmentPlanQueryCriteria.md)
 - [InstallmentPlanResponse](docs/InstallmentPlanResponse.md)
 - [InstallmentPlanStatus](docs/InstallmentPlanStatus.md)
 - [InstallmentStatus](docs/InstallmentStatus.md)
 - [InstallmentsPlanDateType](docs/InstallmentsPlanDateType.md)
 - [IntegrationType](docs/IntegrationType.md)
 - [ItemData](docs/ItemData.md)
 - [LearnMoreDetailsRequest](docs/LearnMoreDetailsRequest.md)
 - [LearnMoreDetailsResponse](docs/LearnMoreDetailsResponse.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [LoginResponse](docs/LoginResponse.md)
 - [MerchantAccountType](docs/MerchantAccountType.md)
 - [MerchantStatus](docs/MerchantStatus.md)
 - [MerchantVertical](docs/MerchantVertical.md)
 - [Money](docs/Money.md)
 - [Money2](docs/Money2.md)
 - [MoneyFlows](docs/MoneyFlows.md)
 - [MoneyWithCurrencyCode](docs/MoneyWithCurrencyCode.md)
 - [OnBoardingMethod](docs/OnBoardingMethod.md)
 - [OperationType](docs/OperationType.md)
 - [PagingRequestHeader](docs/PagingRequestHeader.md)
 - [PagingResponseHeader](docs/PagingResponseHeader.md)
 - [PaymentFormMessage](docs/PaymentFormMessage.md)
 - [PaymentFormMessageType](docs/PaymentFormMessageType.md)
 - [PaymentGatewayMessage](docs/PaymentGatewayMessage.md)
 - [PaymentToken](docs/PaymentToken.md)
 - [PaymentWizardData](docs/PaymentWizardData.md)
 - [PisErrorCodes](docs/PisErrorCodes.md)
 - [PisUserBusinessUnits](docs/PisUserBusinessUnits.md)
 - [PlanApprovalEvidence](docs/PlanApprovalEvidence.md)
 - [PlanData](docs/PlanData.md)
 - [PlanStrategy](docs/PlanStrategy.md)
 - [ProcessorType](docs/ProcessorType.md)
 - [PurchaseMethod](docs/PurchaseMethod.md)
 - [RangeType](docs/RangeType.md)
 - [ReAuthorization](docs/ReAuthorization.md)
 - [ReAuthorizationPaymentGatewayTransactionLogs](docs/ReAuthorizationPaymentGatewayTransactionLogs.md)
 - [RedirectUrls](docs/RedirectUrls.md)
 - [ReferenceEntityBase](docs/ReferenceEntityBase.md)
 - [RefundPlanRequest](docs/RefundPlanRequest.md)
 - [RefundStrategy](docs/RefundStrategy.md)
 - [RefundUnderCancelation](docs/RefundUnderCancelation.md)
 - [RelationsLoad](docs/RelationsLoad.md)
 - [RequestHeader](docs/RequestHeader.md)
 - [ResponseHeader](docs/ResponseHeader.md)
 - [Schedule](docs/Schedule.md)
 - [ScheduleElements](docs/ScheduleElements.md)
 - [ScpProvidersCurrencies](docs/ScpProvidersCurrencies.md)
 - [SessionAvailibility](docs/SessionAvailibility.md)
 - [SplititEntity](docs/SplititEntity.md)
 - [StartInstallmentsRequest](docs/StartInstallmentsRequest.md)
 - [SystemEmailsTypes](docs/SystemEmailsTypes.md)
 - [SystemTextCategory](docs/SystemTextCategory.md)
 - [TerminalCountries](docs/TerminalCountries.md)
 - [TermsAndConditions](docs/TermsAndConditions.md)
 - [TermsAndConditionsGetRequest](docs/TermsAndConditionsGetRequest.md)
 - [TermsAndConditionsGetResponse](docs/TermsAndConditionsGetResponse.md)
 - [TestCardRequest](docs/TestCardRequest.md)
 - [TestModes](docs/TestModes.md)
 - [TouchPoint](docs/TouchPoint.md)
 - [TransactionInfo](docs/TransactionInfo.md)
 - [TransactionResult](docs/TransactionResult.md)
 - [TransactionStatus](docs/TransactionStatus.md)
 - [TransactionType](docs/TransactionType.md)
 - [User](docs/User.md)
 - [UserPermissionLevel](docs/UserPermissionLevel.md)
 - [UserStatus](docs/UserStatus.md)
 - [UserType](docs/UserType.md)
 - [VerifyPaymentRequest](docs/VerifyPaymentRequest.md)
 - [VerifyPaymentResponse](docs/VerifyPaymentResponse.md)
 - [AccountUpdaterPendingCards](docs/AccountUpdaterPendingCards.md)
 - [AccountUpdaterSubscribersScopes](docs/AccountUpdaterSubscribersScopes.md)
 - [AddressData](docs/AddressData.md)
 - [Agents](docs/Agents.md)
 - [AmountDetails](docs/AmountDetails.md)
 - [AuditLogs](docs/AuditLogs.md)
 - [BinDataItems](docs/BinDataItems.md)
 - [BusinessUnits](docs/BusinessUnits.md)
 - [CardStateLogs](docs/CardStateLogs.md)
 - [Cards](docs/Cards.md)
 - [CartItems](docs/CartItems.md)
 - [CollectDocuments](docs/CollectDocuments.md)
 - [ConfigKeys](docs/ConfigKeys.md)
 - [ConfigValues](docs/ConfigValues.md)
 - [ConsumerData](docs/ConsumerData.md)
 - [Countries](docs/Countries.md)
 - [CountrySubdivisions](docs/CountrySubdivisions.md)
 - [CreateInstallmentsPlanResponse](docs/CreateInstallmentsPlanResponse.md)
 - [Currencies](docs/Currencies.md)
 - [Currency](docs/Currency.md)
 - [DEKData](docs/DEKData.md)
 - [EmailAuditLogs](docs/EmailAuditLogs.md)
 - [FeeRateCollections](docs/FeeRateCollections.md)
 - [FeeRates](docs/FeeRates.md)
 - [FeesDocuments](docs/FeesDocuments.md)
 - [FeesRuleDatas](docs/FeesRuleDatas.md)
 - [FraudDetectionLogs](docs/FraudDetectionLogs.md)
 - [FundingCollectDocumentDetails](docs/FundingCollectDocumentDetails.md)
 - [FundingPayDocumentDetails](docs/FundingPayDocumentDetails.md)
 - [FundingRuleDataScpProviderSetting](docs/FundingRuleDataScpProviderSetting.md)
 - [GetInstallmentsPlanExtendedResponse](docs/GetInstallmentsPlanExtendedResponse.md)
 - [InitiateInstallmentsPlanResponse](docs/InitiateInstallmentsPlanResponse.md)
 - [InstallmentPlanEventSubscriberRecordSendLogs](docs/InstallmentPlanEventSubscriberRecordSendLogs.md)
 - [InstallmentPlanEventSubscriberRecords](docs/InstallmentPlanEventSubscriberRecords.md)
 - [InstallmentPlanEvents](docs/InstallmentPlanEvents.md)
 - [InstallmentPlanEventsSubscriptionDatas](docs/InstallmentPlanEventsSubscriptionDatas.md)
 - [InstallmentPlanSetupContexts](docs/InstallmentPlanSetupContexts.md)
 - [InstallmentPlanStatusLogEntries](docs/InstallmentPlanStatusLogEntries.md)
 - [InstallmentPlanTerminalDatas](docs/InstallmentPlanTerminalDatas.md)
 - [InstallmentPlans](docs/InstallmentPlans.md)
 - [Installments](docs/Installments.md)
 - [Keks](docs/Keks.md)
 - [MerchantRef](docs/MerchantRef.md)
 - [Merchants](docs/Merchants.md)
 - [ParameterGroups](docs/ParameterGroups.md)
 - [Parameters](docs/Parameters.md)
 - [PayDocuments](docs/PayDocuments.md)
 - [PaymentFormTPABTestingDefinition](docs/PaymentFormTPABTestingDefinition.md)
 - [PaymentGatewayTransactionAsyncLogs](docs/PaymentGatewayTransactionAsyncLogs.md)
 - [PaymentGatewayTransactionLogs](docs/PaymentGatewayTransactionLogs.md)
 - [PaymentWizardDataResponse](docs/PaymentWizardDataResponse.md)
 - [PisSessions](docs/PisSessions.md)
 - [ProcessorAuthenticationParameters](docs/ProcessorAuthenticationParameters.md)
 - [Processors](docs/Processors.md)
 - [ReAuthorizations](docs/ReAuthorizations.md)
 - [ReconciliationReportItems](docs/ReconciliationReportItems.md)
 - [ReconciliationReports](docs/ReconciliationReports.md)
 - [RefundInstallmentPlanResponse](docs/RefundInstallmentPlanResponse.md)
 - [RefundLogEntries](docs/RefundLogEntries.md)
 - [Roles](docs/Roles.md)
 - [SalesAssociates](docs/SalesAssociates.md)
 - [ScpProviders](docs/ScpProviders.md)
 - [SplititJobDefinitions](docs/SplititJobDefinitions.md)
 - [StateLimitRuleDatas](docs/StateLimitRuleDatas.md)
 - [TerminalGatewayDatas](docs/TerminalGatewayDatas.md)
 - [TerminalKvps](docs/TerminalKvps.md)
 - [Terminals](docs/Terminals.md)
 - [Tokens](docs/Tokens.md)
 - [TouchPointColorValues](docs/TouchPointColorValues.md)
 - [TouchPoints](docs/TouchPoints.md)
 - [TransferDocumentDetails](docs/TransferDocumentDetails.md)
 - [TransferDocuments](docs/TransferDocuments.md)
 - [UpdateInstallmentPlanRequest](docs/UpdateInstallmentPlanRequest.md)
 - [UpdateInstallmentsPlanResponse](docs/UpdateInstallmentsPlanResponse.md)
 - [User2](docs/User2.md)
 - [UserJobSubscriptions](docs/UserJobSubscriptions.md)
 - [UserPasswordHistory](docs/UserPasswordHistory.md)
 - [VersionedTouchPoints](docs/VersionedTouchPoints.md)
 - [ZipAddressDetails](docs/ZipAddressDetails.md)
 - [ApiUserPasswordHistories](docs/ApiUserPasswordHistories.md)
 - [ApiUsers](docs/ApiUsers.md)
 - [ApplicativeUser](docs/ApplicativeUser.md)
 - [ApplicativeUserPasswordHistory](docs/ApplicativeUserPasswordHistory.md)
 - [ExtendedCurrency](docs/ExtendedCurrency.md)
 - [InstallmentPlanAuditLogs](docs/InstallmentPlanAuditLogs.md)
 - [PisMemberPasswordHistories](docs/PisMemberPasswordHistories.md)
 - [PisMembers](docs/PisMembers.md)
 - [PisUserPasswordHistories](docs/PisUserPasswordHistories.md)
 - [UserWithActionItem](docs/UserWithActionItem.md)
 - [PisUsers](docs/PisUsers.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author



